/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.cooldowns;

import java.util.HashMap;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.utils.FileManager;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class CooldownManager {
    private final HashMap<UUID, Long> map = new HashMap();
    FileManager fm = AuctionHouse.getInstance().getFileManager();
    YamlConfiguration cooldownFile;

    public CooldownManager() {
        if (!this.fm.getFile("/database/cooldowns").exists()) {
            this.fm.createFile("/database/cooldowns");
        }
        this.loadCooldowns();
    }

    public boolean isCooldown(Player player) {
        if (this.map.containsKey(player.getUniqueId())) {
            if (this.map.get(player.getUniqueId()) <= System.currentTimeMillis()) {
                this.map.remove(player.getUniqueId());
                return false;
            }
            return true;
        }
        return false;
    }

    public int getRemaining(Player player) {
        if (this.map.containsKey(player.getUniqueId())) {
            if (this.map.get(player.getUniqueId()) <= System.currentTimeMillis()) {
                this.map.remove(player.getUniqueId());
                return 0;
            }
            return (int)(this.map.get(player.getUniqueId()) - System.currentTimeMillis()) / 1000;
        }
        return 0;
    }

    public void setCooldown(Player player) {
        this.map.put(player.getUniqueId(), System.currentTimeMillis() + (long)AuctionHouse.getInstance().getConfigFile().getListingDelay() * 1000L);
    }

    public void saveCooldowns() {
        this.cooldownFile = this.fm.getConfig("/database/cooldowns");
        this.cooldownFile.set("Cooldowns", null);
        int saved = 0;
        HashMap<UUID, Long> copy = new HashMap<UUID, Long>(this.map);
        for (UUID uuid : copy.keySet()) {
            if (this.map.get(uuid) <= System.currentTimeMillis()) {
                this.map.remove(uuid);
                continue;
            }
            this.cooldownFile.set("Cooldowns." + uuid.toString(), (Object)this.map.get(uuid));
            ++saved;
        }
        AuctionHouse.getInstance().getChat().log("Saved " + saved + " cooldowns.", AuctionHouse.getInstance().isDebug());
        this.fm.saveFile(this.cooldownFile, "/database/cooldowns");
    }

    public void loadCooldowns() {
        this.cooldownFile = this.fm.getConfig("/database/cooldowns");
        int loaded = 0;
        if (this.cooldownFile.isConfigurationSection("Cooldowns")) {
            for (String s : this.cooldownFile.getConfigurationSection("Cooldowns").getKeys(false)) {
                UUID uuid = UUID.fromString(s);
                this.map.put(uuid, this.cooldownFile.getLong("Cooldowns." + uuid));
                ++loaded;
            }
        }
        AuctionHouse.getInstance().getChat().log("Loaded " + loaded + " cooldowns.", AuctionHouse.getInstance().isDebug());
    }
}

