/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.commands.main.subcommands;

import java.util.concurrent.atomic.AtomicInteger;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.ConfirmListGUI;
import net.akarian.auctionhouse.users.User;
import net.akarian.auctionhouse.utils.AkarianCommand;
import net.akarian.auctionhouse.utils.Chat;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class ListSubCommand
extends AkarianCommand {
    public ListSubCommand(String name, String permission, String usage, String description, String ... aliases) {
        super(name, permission, usage, description, aliases);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        double price;
        Chat chat = AuctionHouse.getInstance().getChat();
        if (!(sender instanceof Player)) {
            chat.sendMessage(sender, AuctionHouse.getInstance().getMessages().getError_player());
            return;
        }
        if (args.length != 2) {
            chat.usage(sender, AuctionHouse.getInstance().getMessages().getList_syntax());
            return;
        }
        Player p = (Player)sender;
        User user = AuctionHouse.getInstance().getUserManager().getUser(p);
        ItemStack itemStack = p.getInventory().getItemInMainHand();
        if (itemStack.getType().isAir()) {
            chat.sendMessage((CommandSender)p, AuctionHouse.getInstance().getMessages().getList_item());
            return;
        }
        if (p.getGameMode() == GameMode.CREATIVE && !AuctionHouse.getInstance().getConfigFile().isCreativeListing()) {
            chat.sendMessage((CommandSender)p, AuctionHouse.getInstance().getMessages().getSt_creativeListing_message());
            return;
        }
        AtomicInteger maxListings = new AtomicInteger();
        p.getEffectivePermissions().stream().map(PermissionAttachmentInfo::getPermission).map(String::toLowerCase).filter(value -> value.startsWith("auctionhouse.listings.")).map(value -> value.replace("auctionhouse.listings.", "")).forEach(value -> {
            if (value.equalsIgnoreCase("*")) {
                maxListings.set(-1);
            }
            try {
                int amount = Integer.parseInt(value);
                if (amount > maxListings.get()) {
                    maxListings.set(amount);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        if (!p.isOp() && maxListings.get() > 0 && AuctionHouse.getInstance().getListingManager().getActive(p.getUniqueId()).size() >= maxListings.get()) {
            chat.sendMessage((CommandSender)p, AuctionHouse.getInstance().getMessages().getMaxListings().replace("%max%", maxListings.get() + ""));
            return;
        }
        if (AuctionHouse.getInstance().getConfigFile().getListingDelay() > 0 && !p.hasPermission("auctionhouse.delay.bypass") && AuctionHouse.getInstance().getCooldownManager().isCooldown(p)) {
            chat.sendMessage((CommandSender)p, AuctionHouse.getInstance().getMessages().getCooldownTimer().replace("%time%", chat.formatTime(AuctionHouse.getInstance().getCooldownManager().getRemaining(p))));
            return;
        }
        try {
            price = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            chat.sendMessage((CommandSender)p, AuctionHouse.getInstance().getMessages().getList_price());
            return;
        }
        if (price > AuctionHouse.getInstance().getConfigFile().getMaxListing()) {
            chat.sendMessage((CommandSender)p, AuctionHouse.getInstance().getMessages().getMaximumListing().replace("%price%", AuctionHouse.getInstance().getChat().formatMoney(AuctionHouse.getInstance().getConfigFile().getMaxListing())));
            return;
        }
        if (price < AuctionHouse.getInstance().getConfigFile().getMinListing()) {
            chat.sendMessage((CommandSender)p, AuctionHouse.getInstance().getMessages().getMinimumListing().replace("%price%", AuctionHouse.getInstance().getChat().formatMoney(AuctionHouse.getInstance().getConfigFile().getMinListing())));
            return;
        }
        if (AuctionHouse.getInstance().getEcon().getBalance((OfflinePlayer)p) < AuctionHouse.getInstance().getConfigFile().calculateListingFee(price)) {
            chat.sendMessage((CommandSender)p, "&cYou do not have enough money to cover the listing fee.");
            return;
        }
        if (price <= 0.0) {
            chat.sendMessage((CommandSender)p, AuctionHouse.getInstance().getMessages().getList_price());
            return;
        }
        if (user.getUserSettings().isAutoConfirmListing()) {
            AuctionHouse.getInstance().getListingManager().create(p.getUniqueId(), itemStack, price);
        } else {
            p.openInventory(new ConfirmListGUI(p, itemStack, price).getInventory());
        }
    }
}

