/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.commands.main.subcommands;

import java.util.ArrayList;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.commands.main.CommandManager;
import net.akarian.auctionhouse.utils.AkarianCommand;
import net.akarian.auctionhouse.utils.Chat;
import org.bukkit.command.CommandSender;

public class HelpSubCommand
extends AkarianCommand {
    public HelpSubCommand(String name, String permission, String usage, String description, String ... aliases) {
        super(name, permission, usage, description, aliases);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        int page = 1;
        Chat chat = AuctionHouse.getInstance().getChat();
        if (args.length == 2) {
            try {
                page = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                chat.sendMessage(sender, "&cThe second argument must be an integer.");
                return;
            }
        }
        ArrayList<AkarianCommand> commands = new ArrayList<AkarianCommand>();
        for (AkarianCommand command : CommandManager.getInstance().getCommands().values()) {
            if (!sender.hasPermission(command.getPermission()) && !sender.isOp()) continue;
            commands.add(command);
        }
        if (commands.size() == 0) {
            chat.sendRawMessage(sender, "&8&m----------------------------------------");
            chat.sendRawMessage(sender, "&c&l  AuctionHouse Help Menu");
            chat.sendRawMessage(sender, "");
            chat.sendRawMessage(sender, "&cYou do not have any AuctionHouse permissions.");
            chat.sendRawMessage(sender, "&8&m----------------------------------------");
            return;
        }
        chat.sendRawMessage(sender, "&8&m----------------------------------------");
        chat.sendRawMessage(sender, "&c&l  AuctionHouse Help Menu &7(" + page + "/" + (commands.size() % 10 == 0 ? commands.size() / 10 : commands.size() / 10 + 1) + ")");
        chat.sendRawMessage(sender, "");
        chat.sendRawMessage(sender, "&f  <> &8- &fRequired Commands");
        chat.sendRawMessage(sender, "&7  [] &8- &fOptional Commands.");
        chat.sendRawMessage(sender, "");
        int to = page * 10;
        int from = to - 10;
        if (commands.size() >= 10) {
            AkarianCommand command;
            for (int i = from; i < to && commands.size() != i && (command = (AkarianCommand)commands.toArray()[i]) != null; ++i) {
                chat.sendRawMessage(sender, "  &c" + command.getUsage() + " &8- &7" + command.getDescription());
            }
        } else {
            for (AkarianCommand command : commands) {
                chat.sendRawMessage(sender, "  &c" + command.getUsage() + " &8- &7" + command.getDescription());
            }
        }
        chat.sendRawMessage(sender, "&8&m----------------------------------------");
    }
}

