/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.commands.main;

import java.util.HashMap;
import java.util.Map;
import net.akarian.auctionhouse.commands.main.subcommands.ExpiredSubCommand;
import net.akarian.auctionhouse.commands.main.subcommands.HelpSubCommand;
import net.akarian.auctionhouse.commands.main.subcommands.ListSubCommand;
import net.akarian.auctionhouse.commands.main.subcommands.SearchSubCommand;
import net.akarian.auctionhouse.commands.main.subcommands.SettingsSubCommand;
import net.akarian.auctionhouse.utils.AkarianCommand;

public class CommandManager {
    private static CommandManager instance;
    private final Map<String, AkarianCommand> commands = new HashMap<String, AkarianCommand>();

    public CommandManager() {
        instance = this;
        this.commands.put("help", new HelpSubCommand("help", "auctionhouse.help", "/auctionhouse help", "Displays useful information about the plugin.", new String[0]));
        this.commands.put("list", new ListSubCommand("list", "auctionhouse.list", "/auctionhouse list", "Create an AuctionHouse listing", "create", "c", "l", "sell"));
        this.commands.put("search", new SearchSubCommand("search", "auctionhouse.search", "/auctionhouse search <query>", "Open the AuctionHouse Menu with a pre defined search.", new String[0]));
        this.commands.put("expired", new ExpiredSubCommand("expired", "auctionhouse.expired", "/auctionhouse expired", "Open your expired listings.", new String[0]));
        this.commands.put("settings", new SettingsSubCommand("settings", "auctionhouse.settings", "/auctionhouse settings", "View and edit your AuctionHouse settings.", new String[0]));
    }

    public AkarianCommand find(String command) {
        return this.commands.get(command);
    }

    public static CommandManager getInstance() {
        return instance;
    }

    public Map<String, AkarianCommand> getCommands() {
        return this.commands;
    }
}

