/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.commands.admin;

import java.util.HashMap;
import java.util.Map;
import net.akarian.auctionhouse.commands.admin.subcommands.DatabaseSubCommand;
import net.akarian.auctionhouse.commands.admin.subcommands.HelpSubCommand;
import net.akarian.auctionhouse.commands.admin.subcommands.ReloadSubCommand;
import net.akarian.auctionhouse.commands.admin.subcommands.SettingsSubCommand;
import net.akarian.auctionhouse.commands.admin.subcommands.UpdateSubCommand;
import net.akarian.auctionhouse.utils.AkarianCommand;

public class AdminCommandManager {
    private static AdminCommandManager instance;
    private final Map<String, AkarianCommand> commands = new HashMap<String, AkarianCommand>();

    public AdminCommandManager() {
        instance = this;
        this.commands.put("help", new HelpSubCommand("help", "auctionhouse.admin.help", "/aha help", "Displays Admin Commands.", "h"));
        this.commands.put("update", new UpdateSubCommand("update", "auctionhouse.admin.update", "/aha update [enable/disable/toggle]", "Manage the AuctionHouse updater.", "u"));
        this.commands.put("database", new DatabaseSubCommand("database", "auctionhouse.admin.database", "/aha database", "Manage the AuctionHouse database.", "db"));
        this.commands.put("reload", new ReloadSubCommand("reload", "auctionhouse.admin.reload", "/aha reload [messages/config]", "Reload the AuctionHouse files.", "rl"));
        this.commands.put("settings", new SettingsSubCommand("settings", "auctionhouse.admin.settings", "/aha settings", "Manage the default player and server settings.", new String[0]));
    }

    public AkarianCommand find(String command) {
        return this.commands.get(command);
    }

    public static AdminCommandManager getInstance() {
        return instance;
    }

    public Map<String, AkarianCommand> getCommands() {
        return this.commands;
    }
}

