/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.commands.admin;

import java.util.ArrayList;
import java.util.List;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.commands.admin.AdminCommandManager;
import net.akarian.auctionhouse.guis.admin.AuctionHouseAdminGUI;
import net.akarian.auctionhouse.utils.AkarianCommand;
import net.akarian.auctionhouse.utils.Chat;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AHAdminCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String str, String[] args) {
        Chat chat = AuctionHouse.getInstance().getChat();
        long start = System.currentTimeMillis();
        if (args.length == 0) {
            if (sender instanceof Player) {
                Player p = (Player)sender;
                if (p.hasPermission("auctionhouse.admin.manage")) {
                    p.openInventory(new AuctionHouseAdminGUI().getInventory());
                } else {
                    chat.noPermission(sender);
                }
                return false;
            }
            AdminCommandManager.getInstance().find("help").execute(sender, args);
            this.log(start, sender, AdminCommandManager.getInstance().find("help"), args);
            return false;
        }
        AkarianCommand subCommand = AdminCommandManager.getInstance().find(args[0]);
        if (subCommand == null) {
            for (String s : AdminCommandManager.getInstance().getCommands().keySet()) {
                AkarianCommand sc = AdminCommandManager.getInstance().getCommands().get(s);
                for (String aliases : AdminCommandManager.getInstance().getCommands().get(s).getAliases()) {
                    if (!aliases.equalsIgnoreCase(args[0])) continue;
                    if (sender.hasPermission(sc.getPermission()) || sender.isOp()) {
                        sc.execute(sender, args);
                    } else {
                        chat.noPermission(sender);
                    }
                    this.log(start, sender, sc, args);
                    return false;
                }
            }
            chat.sendMessage(sender, "&cInvalid Command. Use /aha help for more info.");
            this.log(start, sender, null, args);
            return false;
        }
        if (sender.hasPermission(subCommand.getPermission()) || sender.isOp()) {
            subCommand.execute(sender, args);
        } else {
            chat.noPermission(sender);
        }
        this.log(start, sender, subCommand, args);
        return false;
    }

    private void log(long time, CommandSender sender, AkarianCommand command, String[] args) {
        String str = command == null ? "UNKNOWN" : command.getName();
        StringBuilder builder = new StringBuilder();
        for (String s : args) {
            builder.append(s).append(" ");
        }
        AuctionHouse.getInstance().getChat().log(sender.getName() + " executed " + str + " in " + (System.currentTimeMillis() - time) + "ms. (" + builder.toString().trim() + ")", AuctionHouse.getInstance().isDebug());
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (sender == null) {
            AHAdminCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            AHAdminCommand.$$$reportNull$$$0(1);
        }
        if (alias == null) {
            AHAdminCommand.$$$reportNull$$$0(2);
        }
        if (args == null) {
            AHAdminCommand.$$$reportNull$$$0(3);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!sender.hasPermission("auctionhouse.admin")) {
            return result;
        }
        if (args.length == 1) {
            result.add("database");
            result.add("help");
            result.add("reload");
            result.add("update");
            result.add("settings");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("update")) {
            result.add("enable");
            result.add("disable");
            result.add("toggle");
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sender";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "command";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "alias";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "args";
                break;
            }
        }
        objectArray[1] = "net/akarian/auctionhouse/commands/admin/AHAdminCommand";
        objectArray[2] = "onTabComplete";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

