/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.akarian.auctionhouse.commands.admin.AHAdminCommand;
import net.akarian.auctionhouse.commands.admin.AdminCommandManager;
import net.akarian.auctionhouse.commands.main.AuctionHouseCommand;
import net.akarian.auctionhouse.commands.main.CommandManager;
import net.akarian.auctionhouse.cooldowns.CooldownManager;
import net.akarian.auctionhouse.events.AuctionHouseGUIEvents;
import net.akarian.auctionhouse.events.ExpireJoinEvent;
import net.akarian.auctionhouse.events.LayoutEditEvents;
import net.akarian.auctionhouse.events.SettingsGUIEvents;
import net.akarian.auctionhouse.events.UpdateJoinEvent;
import net.akarian.auctionhouse.events.UserEvents;
import net.akarian.auctionhouse.events.aahEvents.ListingBoughtEvents;
import net.akarian.auctionhouse.events.aahEvents.ListingCreateEvents;
import net.akarian.auctionhouse.guis.admin.edit.LayoutEditGUI;
import net.akarian.auctionhouse.layouts.LayoutManager;
import net.akarian.auctionhouse.listings.ListingManager;
import net.akarian.auctionhouse.updater.UpdateManager;
import net.akarian.auctionhouse.users.UserManager;
import net.akarian.auctionhouse.utils.AuctionHouseTrait;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.Configuration;
import net.akarian.auctionhouse.utils.DatabaseType;
import net.akarian.auctionhouse.utils.FileManager;
import net.akarian.auctionhouse.utils.GUIManager;
import net.akarian.auctionhouse.utils.Messages;
import net.akarian.auctionhouse.utils.Metrics;
import net.akarian.auctionhouse.utils.MySQL;
import net.akarian.auctionhouse.utils.NameManager;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.TraitInfo;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public final class AuctionHouse
extends JavaPlugin {
    private Economy econ;
    private static AuctionHouse instance;
    private ListingManager listingManager;
    private Chat chat;
    private DatabaseType databaseType;
    private NameManager nameManager;
    private MySQL mySQL;
    private FileManager fileManager;
    private GUIManager guiManager;
    private UpdateManager updateManager;
    private boolean update;
    private Messages messages;
    private Configuration configFile;
    private CooldownManager cooldownManager;
    private UserManager userManager;
    private boolean loaded;
    private boolean debug;
    private LayoutManager layoutManager;

    public void onEnable() {
        this.loaded = false;
        this.getLogger().log(Level.INFO, "========== Akarian Auction House ==========");
        this.getLogger().log(Level.INFO, " ");
        this.getLogger().log(Level.INFO, "Loading Akarian Auction House v" + this.getDescription().getVersion() + "...");
        instance = this;
        this.fileManager = new FileManager((Plugin)this);
        this.configFile = new Configuration();
        this.chat = new Chat((Plugin)this, this.getConfigFile().getPrefix());
        this.chat.log("ChatManager Successfully Loaded", this.debug);
        this.chat.log("Loading NameManager...", this.debug);
        this.nameManager = new NameManager();
        this.chat.log("NameManager Successfully Loaded", this.debug);
        this.chat.log("Loading Messages...", this.debug);
        this.messages = new Messages();
        this.chat.log("Messages Successfully Loaded", this.debug);
        this.chat.log("Loading MySQL...", this.debug);
        this.mySQL = new MySQL();
        this.chat.log("MySQL Successfully Loaded", this.debug);
        this.chat.log("Loading UpdateManager...", this.debug);
        this.update = this.getConfigFile().isUpdates();
        this.updateManager = new UpdateManager(this);
        this.chat.log("UpdateManager Successfully Loaded", this.debug);
        this.chat.log("Loading GUIManager...", this.debug);
        this.guiManager = new GUIManager();
        this.chat.log("GUIManager Successfully Loaded", this.debug);
        this.chat.log("Loading CooldownManager...", this.debug);
        this.cooldownManager = new CooldownManager();
        this.getLogger().log(Level.INFO, "Setting up Economy...");
        if (!this.setupEconomy()) {
            this.chat.alert("&cAuctionHouse has failed to detect an economy. The plugin is now disabling");
            this.chat.log("AuctionHouse disabled due to no found economy.", this.debug);
            this.setEnabled(false);
            return;
        }
        this.getLogger().log(Level.INFO, "Successfully hooked into " + this.econ.getName() + ".");
        this.getLogger().log(Level.INFO, "Loading database...");
        switch (Objects.requireNonNull(this.getConfigFile().getDatabaseType().getStr()).toUpperCase(Locale.ROOT)) {
            case "FILE": {
                this.databaseType = DatabaseType.FILE;
                if (!this.fileManager.getFile("/database/listings").exists()) {
                    this.fileManager.createFile("/database/listings");
                }
                if (!this.fileManager.getFile("/database/expired").exists()) {
                    this.fileManager.createFile("/database/expired");
                }
                if (this.fileManager.getFile("/database/completed").exists()) break;
                this.fileManager.createFile("/database/completed");
                break;
            }
            case "MYSQL": {
                this.databaseType = DatabaseType.MYSQL;
                this.mySQL.setup();
            }
        }
        this.getLogger().log(Level.INFO, "Successfully connected to " + this.databaseType.getStr() + " database.");
        if (this.databaseType != DatabaseType.FILE) {
            if (this.mySQL.isConnected()) {
                this.getLogger().log(Level.INFO, "Successfully loaded MySQL.");
            } else {
                this.getLogger().log(Level.SEVERE, "Failed loaded MySQL.");
            }
        }
        this.getLogger().log(Level.INFO, "Loading listings...");
        this.listingManager = new ListingManager();
        this.getLogger().log(Level.INFO, "Listings loaded successfully.");
        this.getLogger().log(Level.INFO, "Loading users...");
        this.userManager = new UserManager();
        this.getLogger().log(Level.INFO, "Users loaded successfully.");
        this.getLogger().log(Level.INFO, "Loading layouts...");
        this.layoutManager = new LayoutManager();
        this.registerCommands();
        this.registerEvents();
        if (this.getServer().getPluginManager().getPlugin("Citizens") != null && this.getServer().getPluginManager().getPlugin("Citizens").isEnabled()) {
            CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(AuctionHouseTrait.class));
        }
        int pluginId = 15488;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SingleLineChart("active_listings", () -> this.listingManager.getActive().size()));
        metrics.addCustomChart(new Metrics.SingleLineChart("expired_listings", () -> this.listingManager.getExpired().size()));
        metrics.addCustomChart(new Metrics.SingleLineChart("completed_listings", () -> this.listingManager.getCompleted().size()));
        metrics.addCustomChart(new Metrics.SimplePie("database_type", () -> this.databaseType.getStr()));
        this.getLogger().log(Level.INFO, "=================================================");
        this.loaded = true;
    }

    private void registerCommands() {
        new CommandManager();
        new AdminCommandManager();
        this.getCommand("auctionhouse").setExecutor((CommandExecutor)new AuctionHouseCommand());
        this.getCommand("auctionhouse").setTabCompleter((TabCompleter)new AuctionHouseCommand());
        this.getCommand("ahadmin").setExecutor((CommandExecutor)new AHAdminCommand());
        this.getCommand("ahadmin").setTabCompleter((TabCompleter)new AHAdminCommand());
    }

    private void registerEvents() {
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new AuctionHouseGUIEvents(), (Plugin)this);
        pm.registerEvents((Listener)new ExpireJoinEvent(), (Plugin)this);
        pm.registerEvents((Listener)new UpdateJoinEvent(), (Plugin)this);
        pm.registerEvents((Listener)new ListingCreateEvents(), (Plugin)this);
        pm.registerEvents((Listener)new ListingBoughtEvents(), (Plugin)this);
        pm.registerEvents((Listener)new UserEvents(), (Plugin)this);
        pm.registerEvents((Listener)new SettingsGUIEvents(), (Plugin)this);
        pm.registerEvents((Listener)new LayoutEditEvents(), (Plugin)this);
        pm.registerEvents((Listener)this.guiManager, (Plugin)this);
    }

    public void onDisable() {
        if (!this.loaded) {
            this.zipLog();
            this.getLogger().log(Level.INFO, "=================================================");
            return;
        }
        this.listingManager.cancelExpireTimer();
        this.listingManager.cancelRefreshTimer();
        this.layoutManager.saveAllLayouts();
        this.userManager.saveUsers();
        if (this.databaseType != DatabaseType.FILE) {
            this.mySQL.shutdown();
        }
        this.guiManager.closeAllInventories();
        for (UUID uuid : LayoutEditGUI.getLayoutNameEdit().keySet()) {
            LayoutEditGUI.getLayoutNameEdit().get(uuid).restoreInventory(true);
        }
        for (UUID uuid : LayoutEditGUI.getHelpMessage().keySet()) {
            LayoutEditGUI.getHelpMessage().get(uuid).restoreInventory(true);
        }
        for (UUID uuid : LayoutEditGUI.getInventorySizeEdit().keySet()) {
            LayoutEditGUI.getInventorySizeEdit().get(uuid).restoreInventory(true);
        }
        for (UUID uuid : LayoutEditGUI.getDisplayNameEdit().keySet()) {
            LayoutEditGUI.getDisplayNameEdit().get(uuid).restoreInventory(true);
        }
        this.cooldownManager.saveCooldowns();
        this.configFile.saveConfig();
        this.zipLog();
    }

    private boolean setupEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    public String encode(ItemStack itemStack, boolean asOne) {
        String encodedObj;
        ItemStack local = itemStack;
        if (asOne) {
            local.setAmount(1);
        }
        try {
            ByteArrayOutputStream io = new ByteArrayOutputStream();
            BukkitObjectOutputStream os = new BukkitObjectOutputStream((OutputStream)io);
            os.writeObject((Object)local);
            os.flush();
            byte[] serializedObj = io.toByteArray();
            encodedObj = Base64.getEncoder().encodeToString(serializedObj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return encodedObj;
    }

    public ItemStack decode(String string) {
        try {
            byte[] serializedObj = Base64.getDecoder().decode(string);
            ByteArrayInputStream in = new ByteArrayInputStream(serializedObj);
            BukkitObjectInputStream is = new BukkitObjectInputStream((InputStream)in);
            return (ItemStack)is.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void zipLog() {
        try {
            int length;
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDateTime now = LocalDateTime.now();
            String formatted = String.format("%03d", 1);
            String cName = dtf.format(now) + "-" + formatted;
            String dateFile = dtf.format(now);
            if (!new File(this.getDataFolder() + File.separator + "logs/" + dateFile).isDirectory()) {
                new File(this.getDataFolder() + File.separator + "logs/" + dateFile).mkdir();
            }
            if (new File(this.getDataFolder() + File.separator + "logs/" + dateFile + "/" + cName + ".zip").exists()) {
                for (int i = 2; i <= 100; ++i) {
                    formatted = String.format("%03d", i);
                    cName = dtf.format(now) + "-" + formatted;
                    if (!new File(this.getDataFolder() + File.separator + "logs/" + dateFile + "/" + cName + ".zip").exists()) break;
                }
            }
            String sourceFile = "logs/log.txt";
            FileOutputStream fos = new FileOutputStream(this.getDataFolder() + File.separator + "logs/" + dateFile + "/" + cName + ".zip");
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            File fileToZip = new File(this.getDataFolder() + File.separator + sourceFile);
            FileInputStream fis = new FileInputStream(fileToZip);
            ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
            zipOut.close();
            fis.close();
            fos.close();
            if (fileToZip.delete()) {
                AuctionHouse.getInstance().getLogger().log(Level.INFO, "Zipped log " + cName + ".");
            }
        }
        catch (IOException ex) {
            this.chat.log("Error while zipping latest log.", this.debug);
        }
    }

    public Economy getEcon() {
        return this.econ;
    }

    public static AuctionHouse getInstance() {
        return instance;
    }

    public ListingManager getListingManager() {
        return this.listingManager;
    }

    public Chat getChat() {
        return this.chat;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public NameManager getNameManager() {
        return this.nameManager;
    }

    public MySQL getMySQL() {
        return this.mySQL;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public GUIManager getGuiManager() {
        return this.guiManager;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public Configuration getConfigFile() {
        return this.configFile;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }
}

