/*
 * Decompiled with CFR 0.152.
 */
package com.spielefreakj;

import com.spielefreakj.bungee.Events;
import com.spielefreakj.bungee.changeVersion;
import com.spielefreakj.bungee.checkVersion;
import com.spielefreakj.bungee.versioncontrol_cmd;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import org.bstats.bungeecord.Metrics;

public class BungeeMain
extends Plugin {
    private static BungeeMain instance;
    public static String pluginPrefix;
    public String[] messages_read;
    private File file;
    public Configuration config;
    private int pluginId = 13574;

    public void onEnable() {
        BungeeMain.setInstance(this);
        try {
            boolean created_dir;
            if (!this.getDataFolder().exists() && !(created_dir = this.getDataFolder().mkdir())) {
                this.getLogger().info(ChatColor.RED + "Plugin folder could NOT be created! " + ChatColor.GOLD + "Please check your write permissions IMMEDIATELY!");
            }
            this.file = new File(this.getDataFolder() + "/config.yml");
            if (!this.file.exists()) {
                try (InputStream in = this.getResourceAsStream("config.yml");){
                    Files.copy(in, this.file.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.file);
            for (ServerInfo server : ProxyServer.getInstance().getServers().values()) {
                if (this.config.getString("Server.Fallback").equals("")) {
                    this.config.set("Server.Fallback", (Object)server.getName());
                    this.getLogger().info(ChatColor.AQUA + "Version Control: " + ChatColor.GOLD + "There was no Fallback Server. The new fallback server is: " + ChatColor.RED + server.getName());
                }
                if (!this.config.getString("Server." + server.getName() + ".minVersion").equals("") && !this.config.getString("Server." + server.getName() + ".maxVersion").equals("")) continue;
                this.config.set("Server." + server.getName() + ".minVersion", (Object)"47");
                this.config.set("Server." + server.getName() + ".maxVersion", (Object)"9999");
            }
            boolean testfor = false;
            for (ServerInfo sInfo : ProxyServer.getInstance().getServers().values()) {
                if (!this.config.getString("Server.Fallback").equalsIgnoreCase(sInfo.getName())) continue;
                testfor = true;
            }
            if (!testfor && !this.config.getString("Server.Fallback").equalsIgnoreCase("kick")) {
                this.config.set("Server.Fallback", (Object)"kick");
                this.getLogger().info(ChatColor.AQUA + "Version Control: " + ChatColor.GOLD + "The Fallback Server did not exist. Players now get kicked if trying to connect!");
            }
            this.create_messages();
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.config, this.file);
            this.messages_read = this.message_reader();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new changeVersion());
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new checkVersion());
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new versioncontrol_cmd(this.getDescription().getVersion()));
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new Events());
        this.getLogger().info(ChatColor.GREEN + "Version Control Loaded! Made by SpielefreakJ");
        Metrics metrics = new Metrics(this, this.pluginId);
    }

    public void onDisable() {
        this.getLogger().info(ChatColor.RED + "Version Control Disabled! Made by SpielefreakJ");
    }

    public static BungeeMain getInstance() {
        return instance;
    }

    private static void setInstance(BungeeMain instance) {
        BungeeMain.instance = instance;
    }

    public boolean reloadConf() {
        try {
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.file);
            boolean testfor = false;
            for (ServerInfo sInfo : ProxyServer.getInstance().getServers().values()) {
                if (!this.config.getString("Server.Fallback").equalsIgnoreCase(sInfo.getName())) continue;
                testfor = true;
            }
            if (!testfor) {
                this.config.set("Server.Fallback", (Object)"kick");
            }
            this.create_messages();
            this.messages_read = this.message_reader();
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.config, this.file);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveConfig() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.config, this.file);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String[] message_reader() {
        String[] read = new String[50];
        read[0] = this.config.getString("Messages.usage.text");
        read[20] = this.config.getString("Messages.usage.changever");
        read[21] = this.config.getString("Messages.usage.checkver");
        read[25] = this.config.getString("Messages.usage.fallback");
        read[1] = this.config.getString("Messages.error.no_args");
        read[2] = this.config.getString("Messages.error.not_enough_args");
        read[3] = this.config.getString("Messages.error.too_many_args");
        read[4] = this.config.getString("Messages.error.no_server");
        read[5] = this.config.getString("Messages.error.no_server_casing");
        read[22] = this.config.getString("Messages.error.reload");
        read[6] = this.config.getString("Messages.connect.error_multi.after_servername");
        read[7] = this.config.getString("Messages.connect.error_multi.between_versions");
        read[8] = this.config.getString("Messages.connect.error_single");
        read[9] = this.config.getString("Messages.change.before_servername");
        read[10] = this.config.getString("Messages.change.after_servername");
        read[11] = this.config.getString("Messages.change.success_multi.min");
        read[12] = this.config.getString("Messages.change.success_multi.max");
        read[13] = this.config.getString("Messages.change.error.min_over_max");
        read[14] = this.config.getString("Messages.change.error.min_wrong");
        read[15] = this.config.getString("Messages.change.error.max_wrong");
        read[16] = this.config.getString("Messages.check.before_servername");
        read[17] = this.config.getString("Messages.check.multi.after_servername");
        read[18] = this.config.getString("Messages.check.multi.between_versions");
        read[19] = this.config.getString("Messages.check.single.after_servername");
        read[23] = this.config.getString("Messages.modify.fallback.set_to_server");
        read[24] = this.config.getString("Messages.modify.fallback.set_to_kick");
        read[26] = this.config.getString("Messages.fallback.kick_message.multi_part1");
        read[27] = this.config.getString("Messages.fallback.kick_message.multi_part2");
        read[28] = this.config.getString("Messages.fallback.kick_message.single");
        return read;
    }

    public void create_messages() {
        if (this.config.getString("Messages.usage.text").equals("")) {
            this.config.set("Messages.usage.text", (Object)"Usage:");
        }
        if (this.config.getString("Messages.usage.changever").equals("")) {
            this.config.set("Messages.usage.changever", (Object)"/changeversion SERVER MinVersion MaxVersion");
        }
        if (this.config.getString("Messages.usage.checkver").equals("")) {
            this.config.set("Messages.usage.checkver", (Object)"/checkversion SERVER");
        }
        if (this.config.getString("Messages.usage.fallback").equals("")) {
            this.config.set("Messages.usage.fallback", (Object)"/versioncontrol fallback SERVER (or kick to kick)");
        }
        if (this.config.getString("Messages.error.no_args").equals("")) {
            this.config.set("Messages.error.no_args", (Object)"You provided no arguments...");
        }
        if (this.config.getString("Messages.error.not_enough_args").equals("")) {
            this.config.set("Messages.error.not_enough_args", (Object)"You provided not enough arguments.");
        }
        if (this.config.getString("Messages.error.too_many_args").equals("")) {
            this.config.set("Messages.error.too_many_args", (Object)"You provided too many arguments.");
        }
        if (this.config.getString("Messages.error.no_server").equals("")) {
            this.config.set("Messages.error.no_server", (Object)"There is no Server called");
        }
        if (this.config.getString("Messages.error.no_server_casing").equals("")) {
            this.config.set("Messages.error.no_server_casing", (Object)"Please remember this command is case sensitive!");
        }
        if (this.config.getString("Messages.error.reload").equals("")) {
            this.config.set("Messages.error.reload", (Object)"Error during reload. Please read config file!");
        }
        if (this.config.getString("Messages.connect.error_multi.after_servername").equals("")) {
            this.config.set("Messages.connect.error_multi.after_servername", (Object)"is currently only available for Minecraft versions between");
        }
        if (this.config.getString("Messages.connect.error_multi.between_versions").equals("")) {
            this.config.set("Messages.connect.error_multi.between_versions", (Object)"and");
        }
        if (this.config.getString("Messages.connect.error_single").equals("")) {
            this.config.set("Messages.connect.error_single", (Object)"is currently only available for the Minecraft version");
        }
        if (this.config.getString("Messages.change.before_servername").equals("")) {
            this.config.set("Messages.change.before_servername", (Object)"Versions for the server");
        }
        if (this.config.getString("Messages.change.after_servername").equals("")) {
            this.config.set("Messages.change.after_servername", (Object)"has been changed to:");
        }
        if (this.config.getString("Messages.change.success_multi.min").equals("")) {
            this.config.set("Messages.change.success_multi.min", (Object)"Min:");
        }
        if (this.config.getString("Messages.change.success_multi.max").equals("")) {
            this.config.set("Messages.change.success_multi.max", (Object)"Max:");
        }
        if (this.config.getString("Messages.change.error.min_over_max").equals("")) {
            this.config.set("Messages.change.error.min_over_max", (Object)"The minimal version should NOT be bigger than the maximum version!");
        }
        if (this.config.getString("Messages.change.error.min_wrong").equals("")) {
            this.config.set("Messages.change.error.min_wrong", (Object)"The minimal Version was incorrect.");
        }
        if (this.config.getString("Messages.change.error.max_wrong").equals("")) {
            this.config.set("Messages.change.error.max_wrong", (Object)"The maximal Version was incorrect.");
        }
        if (this.config.getString("Messages.check.before_servername").equals("")) {
            this.config.set("Messages.check.before_servername", (Object)"The Server");
        }
        if (this.config.getString("Messages.check.multi.after_servername").equals("")) {
            this.config.set("Messages.check.multi.after_servername", (Object)"is set to the versions");
        }
        if (this.config.getString("Messages.check.multi.between_versions").equals("")) {
            this.config.set("Messages.check.multi.between_versions", (Object)"and");
        }
        if (this.config.getString("Messages.check.single.after_servername").equals("")) {
            this.config.set("Messages.check.single.after_servername", (Object)"is set to the version");
        }
        if (this.config.getString("Messages.modify.fallback.set_to_server").equals("")) {
            this.config.set("Messages.modify.fallback.set_to_server", (Object)"The fallback server is now:");
        }
        if (this.config.getString("Messages.modify.fallback.set_to_kick").equals("")) {
            this.config.set("Messages.modify.fallback.set_to_kick", (Object)"Set fallback event to kick");
        }
        if (this.config.getString("Messages.fallback.kick_message.multi_part1").equals("")) {
            this.config.set("Messages.fallback.kick_message.multi_part1", (Object)"You got kicked from the Server, because the Server is only for Versions");
        }
        if (this.config.getString("Messages.fallback.kick_message.multi_part2").equals("")) {
            this.config.set("Messages.fallback.kick_message.multi_part2", (Object)"and");
        }
        if (this.config.getString("Messages.fallback.kick_message.single").equals("")) {
            this.config.set("Messages.fallback.kick_message.single", (Object)"You got kicked from the Server, because the Server is only for Version");
        }
    }

    static {
        pluginPrefix = "[VersionControl]";
    }
}

