/*
 * Decompiled with CFR 0.152.
 */
package com.holland.keycrates;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import com.holland.keycrates.BlockListener;
import com.holland.keycrates.Icons;
import com.holland.keycrates.InventoryListener;
import com.holland.keycrates.KeyListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public ArrayList<Hologram> activeHolograms = new ArrayList();
    FileConfiguration crates;
    File cfile;

    public void setup(Plugin p) {
        if (!p.getDataFolder().exists()) {
            try {
                p.getDataFolder().createNewFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getLogger().severe("Couldn't create crates folder.");
            }
        }
        this.cfile = new File(p.getDataFolder(), "crates.yml");
        if (!this.cfile.exists()) {
            try {
                this.cfile.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getLogger().severe("Could not create crates.yml");
            }
        }
        this.crates = YamlConfiguration.loadConfiguration((File)this.cfile);
    }

    public FileConfiguration crates() {
        return this.crates;
    }

    public void saveCrates() {
        try {
            this.crates.save(this.cfile);
        }
        catch (IOException e) {
            Bukkit.getServer().getLogger().severe("Couldn't save crates.yml");
        }
    }

    public void onEnable() {
        if (!Bukkit.getPluginManager().isPluginEnabled("HolographicDisplays")) {
            this.getLogger().severe("*** HolographicDisplays is not installed or not enabled. ***");
            this.getLogger().severe("*** This plugin will be disabled. ***");
            this.setEnabled(false);
            return;
        }
        this.getConfig().options().copyDefaults();
        this.saveConfig();
        this.setup((Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new KeyListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(this), (Plugin)this);
        this.reloadHolograms();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (cmd.getName().equalsIgnoreCase("keycrates") || cmd.getName().equalsIgnoreCase("kc")) {
                if (args.length == 0) {
                    p.sendMessage(ChatColor.YELLOW + "-=-=-=-=-=-=-=-=-=- " + ChatColor.GREEN + "KeyCrates" + ChatColor.YELLOW + " -=-=-=-=-=-=-=-=-=-");
                    p.sendMessage(ChatColor.AQUA + "/kc create {id}" + ChatColor.RED + "- Creates a crate at the targeted block.");
                    p.sendMessage(ChatColor.AQUA + "/kc delete {id}" + ChatColor.RED + "- Removes the selected crate.");
                    p.sendMessage(ChatColor.AQUA + "/kc prizes {id}" + ChatColor.RED + "- Manage prizes for selected crate.");
                    p.sendMessage(ChatColor.AQUA + "/kc key {id}" + ChatColor.RED + "- Get a key for the selected crate.");
                    p.sendMessage(ChatColor.AQUA + "/kc list" + ChatColor.RED + "- List all existing crates.");
                    p.sendMessage(ChatColor.AQUA + "/kc title {id} {title}" + ChatColor.RED + "- Set a title for a crate.");
                } else if (args.length == 1) {
                    if (args[0].equalsIgnoreCase("list")) {
                        if (!p.hasPermission("keycrates.list")) {
                            p.sendMessage(ChatColor.YELLOW + "ERROR: " + ChatColor.GREEN + "You don't have the required permission for that.");
                            return false;
                        }
                        p.sendMessage(ChatColor.YELLOW + "-=-=-=-=-=-=-=-=-=- " + ChatColor.GREEN + "KeyCrates" + ChatColor.YELLOW + " -=-=-=-=-=-=-=-=-=-");
                        Set<String> allCrates = this.crateLocations().keySet();
                        for (String crate : allCrates) {
                            p.sendMessage(ChatColor.AQUA + " - " + ChatColor.RED + crate.toUpperCase());
                        }
                    }
                } else if (args.length == 2) {
                    String id;
                    if (args[0].equalsIgnoreCase("create")) {
                        if (!p.hasPermission("keycrates.create")) {
                            p.sendMessage(ChatColor.YELLOW + "ERROR: " + ChatColor.GREEN + "You don't have the required permission for that.");
                            return false;
                        }
                        Block b = p.getTargetBlock(null, 5);
                        double x = b.getLocation().getX();
                        double y = b.getLocation().getY();
                        double z = b.getLocation().getZ();
                        String location = "[" + x + "," + y + "," + z + "]";
                        String world = b.getLocation().getWorld().getName();
                        String id2 = args[1].toLowerCase();
                        this.crates().set("crates." + id2 + ".world", (Object)world);
                        this.crates().set("crates." + id2 + ".location", (Object)location);
                        this.saveCrates();
                        p.playEffect(b.getLocation(), Effect.MOBSPAWNER_FLAMES, 1);
                        p.sendMessage(ChatColor.GREEN + "Success! " + ChatColor.YELLOW + "Created a key crate at " + ChatColor.AQUA + "[" + x + ", " + y + ", " + z + "]");
                        this.reloadHolograms();
                    }
                    if (args[0].equalsIgnoreCase("delete")) {
                        if (!p.hasPermission("keycrates.create")) {
                            p.sendMessage(ChatColor.YELLOW + "ERROR: " + ChatColor.GREEN + "You don't have the required permission for that.");
                            return false;
                        }
                        id = args[1].toLowerCase();
                        if (this.crates().get("crates." + id + ".world") != null) {
                            this.crates().set("crates." + id, null);
                            this.saveCrates();
                            this.reloadHolograms();
                            p.sendMessage(ChatColor.GREEN + "Success! " + ChatColor.YELLOW + "Deleted a key crate with ID " + ChatColor.AQUA + id.toUpperCase());
                        }
                    }
                    if (args[0].equalsIgnoreCase("key")) {
                        if (!p.hasPermission("keycrates.key")) {
                            p.sendMessage(ChatColor.YELLOW + "ERROR: " + ChatColor.GREEN + "You don't have the required permission for that.");
                            return false;
                        }
                        id = args[1].toLowerCase();
                        if (this.crates().get("crates." + id + ".world") != null) {
                            ItemStack key = new ItemStack(Material.TRIPWIRE_HOOK, 1);
                            ItemMeta meta = key.getItemMeta();
                            if (this.crates.get("crates." + id + ".name") != null) {
                                meta.setDisplayName(String.valueOf(this.crates.getString("crates." + id + ".name")) + ChatColor.WHITE + ChatColor.BOLD + " Key");
                            } else {
                                meta.setDisplayName(ChatColor.GREEN + ChatColor.BOLD + id.toUpperCase() + ChatColor.WHITE + ChatColor.BOLD + " Key");
                            }
                            ArrayList<String> lore = new ArrayList<String>();
                            lore.add(ChatColor.YELLOW + "Use this on a " + id.toUpperCase() + " crate.");
                            meta.setLore(lore);
                            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                            key.setItemMeta(meta);
                            p.getInventory().addItem(new ItemStack[]{key});
                            p.sendMessage(ChatColor.GREEN + "Success! " + ChatColor.YELLOW + "Gifted a crate key with for " + ChatColor.AQUA + id.toUpperCase() + " Crate.");
                        }
                    }
                    if (args[0].equalsIgnoreCase("prizes")) {
                        if (!p.hasPermission("keycrates.prizes")) {
                            p.sendMessage(ChatColor.YELLOW + "ERROR: " + ChatColor.GREEN + "You don't have the required permission for that.");
                            return false;
                        }
                        id = args[1].toLowerCase();
                        if (this.crates().get("crates." + id + ".world") == null) {
                            return false;
                        }
                        Inventory gui = Bukkit.createInventory(null, (int)27, (String)(ChatColor.DARK_BLUE + id.toUpperCase() + " Crate Rewards:"));
                        if (this.crates().get("crates." + id + ".prizes") != null) {
                            List<ItemStack> items = Icons.getIcon(id, this);
                            for (ItemStack item : items) {
                                gui.addItem(new ItemStack[]{item});
                            }
                        }
                        p.openInventory(gui);
                    }
                } else if (args.length == 3 && args[0].equalsIgnoreCase("title")) {
                    if (!p.hasPermission("keycrates.title")) {
                        p.sendMessage(ChatColor.YELLOW + "ERROR: " + ChatColor.GREEN + "You don't have the required permission for that.");
                        return false;
                    }
                    String proposedCrate = args[1].toLowerCase();
                    if (this.crates().get("crates." + proposedCrate + ".world") == null) {
                        p.sendMessage(ChatColor.RED + "The selected crate does not exist.");
                        return false;
                    }
                    String setName = ChatColor.translateAlternateColorCodes((char)'&', (String)args[2]);
                    this.crates.set("crates." + proposedCrate + ".name", (Object)setName);
                    this.reloadHolograms();
                }
            }
        }
        return false;
    }

    public Location stringToLocation(String string, World world) {
        if (string != null && string.contains("[") && string.contains("]")) {
            String data = string.replace("[", "").replace("]", "");
            String[] coords = data.split(",");
            double x = Double.parseDouble(coords[0]);
            double y = Double.parseDouble(coords[1]);
            double z = Double.parseDouble(coords[2]);
            Location loc = new Location(world, x, y, z);
            return loc;
        }
        return new Location(Bukkit.getWorld((String)""), 0.0, 0.0, 0.0);
    }

    public void createHologram(String id, Location loc) {
        Hologram hologram = HologramsAPI.createHologram((Plugin)this, (Location)loc);
        TextLine textLine = this.crates.get("crates." + id.toLowerCase() + ".name") != null ? hologram.appendTextLine(this.crates.getString("crates." + id.toLowerCase() + ".name")) : hologram.appendTextLine(ChatColor.GREEN + ChatColor.BOLD + id.toUpperCase());
        TextLine textLine2 = hologram.appendTextLine(ChatColor.WHITE + ChatColor.BOLD + "Crate");
    }

    public void reloadHolograms() {
        for (Hologram holo : HologramsAPI.getHolograms((Plugin)this)) {
            holo.delete();
        }
        HashMap<String, Location> locations = this.crateLocations();
        for (String crateID : locations.keySet()) {
            this.createHologram(crateID.toUpperCase(), locations.get(crateID).add(0.5, 2.0, 0.5));
        }
    }

    public boolean locationsMatch(Location loc1, Location loc2) {
        double x1 = loc1.getX();
        double y1 = loc1.getY();
        double z1 = loc1.getZ();
        double x2 = loc2.getX();
        double y2 = loc2.getY();
        double z2 = loc2.getZ();
        String world1 = loc1.getWorld().getName();
        String world2 = loc2.getWorld().getName();
        return x1 == x2 && y1 == y2 && z1 == z2 && world1.equalsIgnoreCase(world2);
    }

    public HashMap<String, Location> crateLocations() {
        HashMap<String, Location> locations = new HashMap<String, Location>();
        Set keys = this.crates.getKeys(true);
        for (String key : keys) {
            if (!key.contains(".location")) continue;
            String keyID = key.replace("crates.", "").replace(".location", "");
            String locAsString = this.crates.getString(key);
            Location location = this.stringToLocation(locAsString, Bukkit.getWorld((String)this.crates.getString("crates." + keyID + ".world")));
            locations.put(keyID, location);
        }
        return locations;
    }
}

