/*
 * Decompiled with CFR 0.152.
 */
package me.Zrips.bottledexp.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.Zrips.bottledexp.BottledExp;
import me.Zrips.bottledexp.Calculations;
import me.Zrips.bottledexp.ConfigFile;
import me.Zrips.bottledexp.EBlock;
import me.Zrips.bottledexp.EBlockInfo;
import me.Zrips.bottledexp.Language;
import me.Zrips.bottledexp.Util;
import me.Zrips.bottledexp.commands.BottledExpCommand;
import net.Zrips.CMILib.Locale.LC;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BottledExpCommands
implements CommandExecutor {
    private static final String label = "bottle";

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block6: {
            String[] myArgs;
            Method m;
            block8: {
                String cmd;
                block7: {
                    if (args.length == 0) {
                        return this.help(sender);
                    }
                    cmd = args[0].toLowerCase();
                    m = this.getClass().getMethod(cmd, CommandSender.class, String[].class);
                    if (!m.isAnnotationPresent(BottledExpCommand.class)) break block6;
                    if (BottledExpCommands.hasCommandPermission(sender, cmd)) break block7;
                    sender.sendMessage(ChatColor.RED + Language.getMessage("Nopermission"));
                    return true;
                }
                myArgs = BottledExpCommands.reduceArgs(args);
                if (myArgs.length <= 0 || !myArgs[myArgs.length - 1].equals("?")) break block8;
                this.sendUsage(sender, cmd);
                return true;
            }
            try {
                return (Boolean)m.invoke((Object)this, sender, myArgs);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!(sender instanceof Player)) {
            return this.help(sender);
        }
        return this.help(sender);
    }

    private static String[] reduceArgs(String[] args) {
        if (args.length <= 1) {
            return new String[0];
        }
        return Arrays.copyOfRange(args, 1, args.length);
    }

    private static boolean hasCommandPermission(CommandSender sender, String cmd) {
        return sender.hasPermission("bottledexp.command." + cmd);
    }

    private static String getUsage(String cmd) {
        StringBuilder builder = new StringBuilder();
        builder.append(ChatColor.GREEN.toString());
        builder.append('/').append(label).append(' ');
        builder.append(cmd);
        builder.append(ChatColor.YELLOW);
        String key = "command." + cmd + ".help.args";
        if (Language.containsKey(key)) {
            builder.append(' ');
            builder.append(Language.getMessage(key));
        }
        return builder.toString();
    }

    public void sendUsage(CommandSender sender, String cmd) {
        String message = ChatColor.YELLOW + Language.getMessage("command.help.output.usage");
        message = message.replace("%usage%", BottledExpCommands.getUsage(cmd));
        sender.sendMessage(message);
        sender.sendMessage(ChatColor.YELLOW + "* " + Language.getMessage("command." + cmd + ".help.info"));
    }

    protected boolean help(CommandSender sender) {
        sender.sendMessage(Language.getMessage("command.help.output.title"));
        Method[] methodArray = this.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd;
            Method m = methodArray[n2];
            if (m.isAnnotationPresent(BottledExpCommand.class) && BottledExpCommands.hasCommandPermission(sender, cmd = m.getName())) {
                sender.sendMessage(String.valueOf(BottledExpCommands.getUsage(cmd)) + " - " + Language.getMessage("command." + cmd + ".help.info"));
            }
            ++n2;
        }
        return true;
    }

    public static List<String> GetCommands() {
        ArrayList<String> CommandList = new ArrayList<String>();
        Method[] methodArray = ((Object)((Object)BottledExp.plugin)).getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.isAnnotationPresent(BottledExpCommand.class)) {
                CommandList.add(m.getName());
            }
            ++n2;
        }
        return CommandList;
    }

    @BottledExpCommand
    public boolean stats(CommandSender sender, String[] args) {
        if (!(sender instanceof Player) && args.length != 1) {
            return false;
        }
        if (args.length != 0 && args.length != 1) {
            this.sendUsage(sender, "stats");
            return false;
        }
        Player player = null;
        if (args.length == 0) {
            player = (Player)sender;
        } else if (Util.hasPermission(sender, "bottledexp.command.stats.others", true)) {
            player = Bukkit.getPlayer((String)args[0]);
        }
        if (player == null) {
            sender.sendMessage(Language.getMessage("NoPlayer"));
            return false;
        }
        List<String> msgList = Language.getMessageList("command.stats.info.feedback");
        for (String one : msgList) {
            one = one.replace("[xp]", "" + Calculations.getPlayerExperience(player)).replace("[level]", "" + player.getLevel()).replace("[xpdelta]", "" + Calculations.currentlevelxpdelta(player)).replace("[bottles]", "" + Calculations.xptobottles(Calculations.currentlevelxpdelta(player)));
            sender.sendMessage(one);
        }
        if (ConfigFile.useBottleMoney) {
            String msg = Language.getMessage("command.stats.info.Moneyfeedback").replace("[money]", "" + ConfigFile.bottleCost * (double)Calculations.currentlevelxpdelta(player));
            sender.sendMessage(msg);
        }
        return true;
    }

    @BottledExpCommand
    public boolean until(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        if (args.length != 1) {
            this.sendUsage(sender, "until");
            return false;
        }
        Player player = (Player)sender;
        int level = 0;
        try {
            level = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf(Language.getMessage("Prefix")) + Language.getMessage("MoreThanZero"));
            return false;
        }
        if (level <= player.getLevel()) {
            sender.sendMessage(Language.getMessage("command.until.info.moreThan"));
        } else {
            int NeedXpToLevel = Calculations.levelToExp(level) - Calculations.getPlayerExperience(player);
            String msg = Language.getMessage("command.until.info.feedback").replace("[xp]", "" + NeedXpToLevel).replace("[bottles]", "" + Calculations.xptobottles(NeedXpToLevel)).replace("[level]", args[0]);
            sender.sendMessage(msg);
            if (ConfigFile.useBottleMoney) {
                msg = Language.getMessage("command.until.info.Moneyfeedback").replace("[money]", "" + ConfigFile.bottleCost * (double)Calculations.currentlevelxpdelta(player));
                sender.sendMessage(msg);
            }
        }
        return true;
    }

    @BottledExpCommand
    public boolean eblock(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        if (args.length != 0) {
            this.sendUsage(sender, "eblock");
            return false;
        }
        Player player = (Player)sender;
        Block block = player.getTargetBlock(null, 10);
        Location loc = block.getLocation();
        EBlockInfo blocks = BottledExp.getEBlocks();
        EBlock b = blocks.getBlock(loc);
        if (b != null) {
            blocks.removeBlock(b);
            player.sendMessage(Language.getMessage("command.eblock.info.removed"));
            return false;
        }
        EBlock EB = new EBlock();
        EB.setWorld(loc.getWorld().getName());
        EB.setX(loc.getBlockX());
        EB.setY(loc.getBlockY());
        EB.setZ(loc.getBlockZ());
        blocks.addBlock(EB);
        BottledExp.getConfigManager().saveBlocks();
        player.sendMessage(Language.getMessage("command.eblock.info.created"));
        return true;
    }

    @BottledExpCommand
    public boolean get(CommandSender sender, String[] args) {
        Player player;
        if (args.length != 1 && args.length != 2) {
            this.sendUsage(sender, "get");
            return false;
        }
        int amount = 0;
        boolean max = false;
        String playerName = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            block15: {
                String one = stringArray[n2];
                if (one.equalsIgnoreCase("max")) {
                    max = true;
                } else {
                    if (amount == 0) {
                        try {
                            amount = Integer.parseInt(one);
                            break block15;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    playerName = one;
                }
            }
            ++n2;
        }
        if (playerName != null && !playerName.equalsIgnoreCase(sender.getName()) && !Util.hasPermission(sender, "bottledexp.command.get.others", true)) {
            return false;
        }
        Player player2 = player = playerName == null && sender instanceof Player ? (Player)sender : Bukkit.getPlayer((String)playerName);
        if (player == null || !player.isOnline()) {
            LC.info_NoPlayer.sendMessage((Object)sender, new Object[0]);
            return false;
        }
        int currentxp = Calculations.getPlayerExperience(player);
        if (max) {
            if (!Util.hasPermission((CommandSender)player, "bottledexp.command.get.max", true)) {
                return false;
            }
            amount = currentxp / ConfigFile.xpCost;
            if (ConfigFile.settingUseItems && Calculations.countItems(player, ConfigFile.settingConsumedItem) < amount) {
                player.sendMessage(Language.getMessage("command.get.info.NoItems"));
                return false;
            }
            if (ConfigFile.useVaultEcon && ConfigFile.useBottleMoney && Util.getBalance(player) / (double)ConfigFile.moneyCost < 1.0) {
                player.sendMessage(Language.getMessage("command.get.info.NoMoney"));
                return false;
            }
            if (amount == 0) {
                player.sendMessage(Language.getMessage("command.get.info.noExp"));
                return false;
            }
            Util.giveBoottles(player, amount);
            return true;
        }
        if (amount < 1) {
            sender.sendMessage(Language.getMessage("MoreThanZero"));
            return false;
        }
        Util.giveBoottles(player, amount);
        return true;
    }

    @BottledExpCommand
    public boolean store(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        if (args.length < 1 || args.length > 2) {
            this.sendUsage(sender, "store");
            return false;
        }
        Player player = (Player)sender;
        int take = 0;
        boolean max = false;
        boolean levels = false;
        String value = args[0];
        if (args[0].toLowerCase().endsWith("l")) {
            levels = true;
            value = value.substring(0, value.length() - 1);
        }
        if (args[0].equals("max")) {
            if (!Util.hasPermission((CommandSender)player, "bottledexp.command.store.max", true)) {
                return true;
            }
            max = true;
        } else {
            try {
                take = Integer.parseInt(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (levels && take > player.getLevel()) {
            take = player.getLevel();
        }
        if (levels) {
            int expTo1 = Calculations.levelToExp(player.getLevel() - take);
            int expTo2 = Calculations.levelToExp(player.getLevel());
            take = take == player.getLevel() ? Calculations.getPlayerExperience(player) : expTo2 - expTo1;
        }
        if (max) {
            take = Calculations.getPlayerExperience(player);
        }
        if (take <= 0) {
            this.sendUsage(sender, "store");
            return true;
        }
        int give = (int)Math.floor(Double.valueOf(take) / (Double.valueOf(ConfigFile.xpCost) / Double.valueOf(ConfigFile.xpEarn)));
        if (ConfigFile.settingUseItems && Calculations.countItems(player, ConfigFile.settingConsumedItem) < 1) {
            player.sendMessage(Language.getMessage("command.get.info.NoItems"));
            return true;
        }
        if (ConfigFile.useVaultEcon && Util.getBalance(player) < (double)ConfigFile.moneyCost) {
            player.sendMessage(Language.getMessage("command.get.info.NoMoney"));
            return true;
        }
        if (take <= 0) {
            player.sendMessage(Language.getMessage("command.get.info.noExp"));
            return true;
        }
        Util.giveStoredBoottle(player, take, give);
        return true;
    }

    @BottledExpCommand
    public boolean give(CommandSender sender, String[] args) {
        int exp;
        if (!(sender instanceof Player)) {
            return false;
        }
        if (args.length != 2) {
            this.sendUsage(sender, "give");
            return false;
        }
        Player player = (Player)sender;
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            player.sendMessage(Language.getMessage("NoPlayer"));
            return false;
        }
        if (args[0].equalsIgnoreCase(player.getName())) {
            player.sendMessage(Language.getMessage("Self"));
            return false;
        }
        try {
            exp = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf(Language.getMessage("Prefix")) + Language.getMessage("MoreThanZero"));
            return false;
        }
        if (exp > Calculations.getPlayerExperience(player)) {
            Language.getMessage("command.give.info.noExp");
            return false;
        }
        if (exp < 1) {
            sender.sendMessage(Language.getMessage("MoreThanZero"));
            return false;
        }
        int giverExp = Calculations.getPlayerExperience(player) - exp;
        int expToReceive = exp * (100 - ConfigFile.LostDurringTransfer) / 100;
        int lostExp = exp - expToReceive;
        int receiversExp = Calculations.getPlayerExperience(target) + expToReceive;
        player.setLevel(0);
        player.setExp(0.0f);
        player.setTotalExperience(0);
        player.giveExp(giverExp);
        target.setLevel(0);
        target.setExp(0.0f);
        target.setTotalExperience(0);
        target.giveExp(receiversExp);
        String msg = Language.getMessage("command.give.info.sender").replace("[amount]", args[1]).replace("[name]", target.getName()).replace("[lost]", String.valueOf(lostExp));
        player.sendMessage(msg);
        msg = Language.getMessage("command.give.info.receiver").replace("[amount]", String.valueOf(expToReceive)).replace("[name]", sender.getName()).replace("[lost]", String.valueOf(lostExp));
        target.sendMessage(msg);
        return true;
    }

    @BottledExpCommand
    public boolean reload(CommandSender sender, String[] args) {
        BottledExp.getConfigManager().reload(sender, true);
        return true;
    }
}

