/*
 * Decompiled with CFR 0.152.
 */
package me.Zrips.bottledexp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.Zrips.bottledexp.BottledExp;
import me.Zrips.bottledexp.Calculations;
import me.Zrips.bottledexp.ConfigFile;
import me.Zrips.bottledexp.Language;
import me.Zrips.bottledexp.Util;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Util.CMIVersionChecker;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.PluginDescriptionFile;

public class EventListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onVillagerTrade(PlayerInteractEntityEvent event) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (!ConfigFile.DisableVillagerExpTrade) {
            return;
        }
        if (event.getRightClicked().getType() != EntityType.VILLAGER) {
            return;
        }
        Player player = event.getPlayer();
        BottledExp.getNms().disableTrade(event.getRightClicked(), player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onExpBottleEvent(ExpBottleEvent event) {
        block11: {
            event.setExperience(ConfigFile.xpEarn);
            try {
                ItemStack item = event.getEntity().getItem();
                CMINBT nbt = new CMINBT(item);
                if (nbt.hasNBT("StoredBottledExp") && nbt.getInt("StoredBottledExp") != null) {
                    Integer exp = nbt.getInt("StoredBottledExp");
                    if (exp > 0) {
                        event.setExperience(exp.intValue());
                    }
                    break block11;
                }
                if (!item.hasItemMeta()) {
                    return;
                }
                ItemMeta meta = item.getItemMeta();
                if (!meta.hasDisplayName()) {
                    return;
                }
                if (!meta.getDisplayName().equalsIgnoreCase(Language.getMessage("Store.Name"))) {
                    return;
                }
                List lore = item.getItemMeta().getLore();
                if (lore.size() != 2) {
                    return;
                }
                int exp = 0;
                try {
                    exp = Integer.parseInt(ChatColor.stripColor((String)((String)lore.get(1))));
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (exp < 1) {
                    return;
                }
                event.setExperience(exp);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!ConfigFile.DisableMobSpawnerExp) {
            return;
        }
        Block block = event.getBlock();
        if (!CMIMaterial.get((Block)block).equals((Object)CMIMaterial.SPAWNER)) {
            return;
        }
        event.setExpToDrop(0);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onitemCraft(CraftItemEvent event) {
        if (!ConfigFile.CraftExpContainer) {
            return;
        }
        switch (event.getAction()) {
            case NOTHING: 
            case PLACE_ALL: 
            case PLACE_SOME: 
            case PLACE_ONE: {
                return;
            }
        }
        if (!(event.getInventory() instanceof CraftingInventory) || !event.getSlotType().equals((Object)InventoryType.SlotType.RESULT)) {
            return;
        }
        ItemStack resultStack = event.getRecipe().getResult();
        if (resultStack == null) {
            return;
        }
        if (!CMIMaterial.get((ItemStack)resultStack).equals((Object)CMIMaterial.EXPERIENCE_BOTTLE)) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (!item.hasItemMeta()) {
            return;
        }
        CMINBT nbt = new CMINBT(item);
        if (!nbt.hasNBT("StoredBottledExp")) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!Util.hasPermission((CommandSender)player, "bottledexp.expcontainer.craft", true)) {
            event.setCancelled(true);
            return;
        }
        if (event.getClick() != ClickType.LEFT && event.getClick() != ClickType.RIGHT) {
            event.setCancelled(true);
            return;
        }
        if (player.getInventory().firstEmpty() == -1 && event.isShiftClick()) {
            event.setCancelled(true);
            return;
        }
        int exp = Calculations.getPlayerExperience((Player)event.getView().getPlayer());
        if (exp == 0) {
            event.setCancelled(true);
            return;
        }
        nbt = new CMINBT(resultStack);
        resultStack = (ItemStack)nbt.setInt("StoredBottledExp", Integer.valueOf(exp));
        ItemMeta meta = resultStack.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        int level = Calculations.expToLevel(exp, 10000.0);
        lore.addAll(Arrays.asList(Language.getMessage("Store.BottleLore").replace("[exp]", String.valueOf(exp)).replace("[level]", String.valueOf(level)).replace("[lvl]", String.valueOf(level)).split("\\\\n")));
        meta.setDisplayName(Language.getMessage("Store.Name").replace("[exp]", String.valueOf(exp)).replace("[level]", String.valueOf(level)).replace("[lvl]", String.valueOf(level)));
        meta.setLore(lore);
        resultStack.setItemMeta(meta);
        event.getInventory().setResult(resultStack);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!event.isLeftClick() && !event.isRightClick()) {
            return;
        }
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setExp(0.0f);
        player.setTotalExperience(0);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onExpBottleThrow(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = CMIItemStack.getItemInMainHand((Player)player);
        if (item == null) {
            return;
        }
        int exp = 0;
        CMINBT nbt = new CMINBT(item);
        if (nbt.hasNBT("StoredBottledExp") && nbt.getInt("StoredBottledExp") != null) {
            exp = nbt.getInt("StoredBottledExp");
        } else {
            if (!item.hasItemMeta()) {
                return;
            }
            if (!item.getItemMeta().hasDisplayName()) {
                return;
            }
            if (!item.getItemMeta().hasLore()) {
                return;
            }
            if (!item.getItemMeta().getDisplayName().equalsIgnoreCase(Language.getMessage("Store.Name"))) {
                return;
            }
            List lore = item.getItemMeta().getLore();
            if (lore.size() != 2) {
                return;
            }
            try {
                exp = Integer.parseInt(ChatColor.stripColor((String)((String)lore.get(1))));
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        if (exp <= 0) {
            return;
        }
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            CMIItemStack.setItemInMainHand((Player)player, null);
        }
        player.updateInventory();
        int newexp = Calculations.getPlayerExperience(player) + exp;
        player.setLevel(0);
        player.setExp(0.0f);
        player.setTotalExperience(0);
        player.giveExp(newexp);
        event.setCancelled(true);
        player.sendMessage(Language.getMessage("GotExp").replace("[xp]", "" + exp));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onitemCraft(PrepareItemCraftEvent e) {
        if (!ConfigFile.CraftExpContainer) {
            return;
        }
        ItemStack[] items = e.getInventory().getContents();
        int found = 0;
        int i = 1;
        while (i < items.length) {
            if (items[i].getType() == Material.GLASS_BOTTLE) {
                ++found;
            }
            ++i;
        }
        if (found != 1) {
            return;
        }
        ItemStack item = e.getInventory().getResult();
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        ArrayList<String> lore = new ArrayList<String>();
        int exp = Calculations.getPlayerExperience((Player)e.getView().getPlayer());
        if (exp == 0) {
            e.getInventory().setResult(null);
            return;
        }
        int level = Calculations.expToLevel(exp, 10000.0);
        meta.setDisplayName(Language.getMessage("Store.Name").replace("[exp]", String.valueOf(exp)).replace("[level]", String.valueOf(level)).replace("[lvl]", String.valueOf(level)));
        lore.addAll(Arrays.asList(Language.getMessage("Store.BottleLore").replace("[exp]", String.valueOf(exp)).replace("[level]", String.valueOf(level)).replace("[lvl]", String.valueOf(level)).split("\\\\n")));
        meta.setLore(lore);
        item.setItemMeta(meta);
        CMINBT nbt = new CMINBT(item);
        item = (ItemStack)nbt.setInt("StoredBottledExp", Integer.valueOf(exp));
        e.getInventory().setResult(item);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEnchantItem(EnchantItemEvent event) {
        int takenxp;
        int xptoleave;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getEnchanter();
        int PlayerLevel = player.getLevel();
        int getExpLevelCost = event.getExpLevelCost();
        int EnchantLevel = ConfigFile.UseThreeButtonEnchant ? event.whichButton() + 1 : getExpLevelCost - event.whichButton() - 1;
        int leveltoleave = PlayerLevel - EnchantLevel;
        int levelxp = Calculations.getPlayerExperience(player) - Calculations.levelToExp(PlayerLevel);
        double percentage = levelxp * 100 / Calculations.deltaLevelToExp(PlayerLevel);
        int newlevelpercentagexp = (int)((double)Calculations.deltaLevelToExp(leveltoleave) * percentage / 100.0);
        if (ConfigFile.UseThreeButtonEnchant) {
            xptoleave = Calculations.levelToExp(leveltoleave) + newlevelpercentagexp;
            takenxp = Calculations.getPlayerExperience(player) - xptoleave;
        } else {
            xptoleave = Calculations.levelToExp(PlayerLevel - getExpLevelCost) + newlevelpercentagexp;
            takenxp = Calculations.getPlayerExperience(player) - xptoleave;
        }
        if (ConfigFile.ShowEnchantExp) {
            player.sendMessage(ChatColor.GREEN + Language.getMessage("Enchant").replace("[xp]", String.valueOf(takenxp)));
        }
        if (ConfigFile.ShowEnchant) {
            Map enchantmentName = event.getEnchantsToAdd();
            int i = event.getEnchantsToAdd().size();
            String enchantString = "";
            String enchantStringFull = "";
            for (Map.Entry entry : enchantmentName.entrySet()) {
                enchantString = ((Enchantment)entry.getKey()).getName();
                Integer enchantlevel = (Integer)entry.getValue();
                enchantString = ChatColor.DARK_GREEN + Calculations.toSentenceCase(enchantString) + ": " + ChatColor.DARK_AQUA + enchantlevel + ChatColor.DARK_GREEN;
                enchantStringFull = --i >= 2 ? String.valueOf(enchantStringFull) + enchantString + ", " : (i >= 1 ? String.valueOf(enchantStringFull) + enchantString + " and " : String.valueOf(enchantStringFull) + enchantString);
            }
            player.sendMessage(ChatColor.DARK_GREEN + enchantStringFull);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("bottledexp.versioncheck")) {
            CMIVersionChecker.VersionCheck((Player)player, (int)2815, (PluginDescriptionFile)BottledExp.getInstance().getDescription());
        }
    }
}

