/*
 * Decompiled with CFR 0.152.
 */
package de.CraftCode.Login;

import de.CraftCode.Login.Main;
import de.CraftCode.Login.xLoginCommands;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class Listeners
implements Listener {
    private Main plugin;
    private List<String> cooldown = new ArrayList<String>();

    public Listeners(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onFood(FoodLevelChangeEvent e) {
        Player p;
        if (e.getEntity() instanceof Player && !this.plugin.loggedIn.contains((p = (Player)e.getEntity()).getName())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        final Player p = e.getPlayer();
        if (!this.plugin.loggedIn.contains(p.getName()) && e.getFrom().toVector().getBlockX() == e.getTo().toVector().getBlockX() && e.getFrom().toVector().getBlockZ() == e.getTo().toVector().getBlockZ()) {
            e.setCancelled(true);
            if (!this.cooldown.contains(p.getName())) {
                this.cooldown.add(p.getName());
                xLoginCommands cmd = new xLoginCommands(this.plugin);
                if (cmd.isRegistered(p)) {
                    p.sendMessage(String.valueOf(this.plugin.prefix) + "\u00a76Bitte logge dich ein /login \u00bb \u00a7cPassword \u00a76\u00ab");
                } else {
                    p.sendMessage(String.valueOf(this.plugin.prefix) + "\u00a76Bitte registriere dich mit /register \u00bb \u00a7cPassword \u00a76\u00ab");
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        if (p != null) {
                            Listeners.this.cooldown.remove(p.getName());
                        }
                    }
                }, 20L);
            }
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        if (this.plugin.loggedIn.contains(e.getPlayer().getName())) {
            this.plugin.loggedIn.remove(e.getPlayer().getName());
        }
    }

    @EventHandler
    public void onKick(PlayerKickEvent e) {
        if (this.plugin.loggedIn.contains(e.getPlayer().getName())) {
            this.plugin.loggedIn.remove(e.getPlayer().getName());
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        xLoginCommands cmd = new xLoginCommands(this.plugin);
        Player p = e.getPlayer();
        if (cmd.isRegistered(p)) {
            p.sendMessage(String.valueOf(this.plugin.prefix) + "\u00a76Bitte logge dich ein /login \u00bb \u00a7cPassword \u00a76\u00ab");
        } else {
            p.sendMessage(String.valueOf(this.plugin.prefix) + "\u00a76Bitte registriere dich mit /register \u00bb \u00a7cPassword \u00a76\u00ab");
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent e) {
        Player p;
        if (e.getEntity() instanceof Player && !this.plugin.loggedIn.contains((p = (Player)e.getEntity()).getName())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        Player d;
        if (e.getDamager() instanceof Player && !this.plugin.loggedIn.contains((d = (Player)e.getDamager()).getName())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockbreak(BlockBreakEvent e) {
        if (!this.plugin.loggedIn.contains(e.getPlayer().getName())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockplace(BlockPlaceEvent e) {
        if (!this.plugin.loggedIn.contains(e.getPlayer().getName())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        if (!this.plugin.loggedIn.contains(e.getPlayer().getName())) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(String.valueOf(this.plugin.prefix) + "\u00a7cDu musst eingeloggt sein!");
        }
    }

    @EventHandler
    public void onCMD(PlayerCommandPreprocessEvent e) {
        if (!this.plugin.loggedIn.contains(e.getPlayer().getName())) {
            if (e.getMessage().startsWith("/login")) {
                e.setCancelled(false);
                return;
            }
            if (e.getMessage().startsWith("/register")) {
                e.setCancelled(false);
                return;
            }
            if (e.getMessage().startsWith("/l")) {
                e.setCancelled(false);
                return;
            }
            if (e.getMessage().startsWith("/reg")) {
                e.setCancelled(false);
                return;
            }
            e.setCancelled(true);
        }
    }
}

