/*
 * Decompiled with CFR 0.152.
 */
package me.Joshb.TpLogin.Configs;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.Joshb.TpLogin.Core;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class UserCache {
    String fileName = "usercache.yml";
    FileConfiguration config;
    File file = new File(Core.plugin.getDataFolder(), this.fileName);
    private static UserCache instance = new UserCache();

    public static UserCache getInstance() {
        return instance;
    }

    public void loadConfig() {
        this.createIfNotExist();
        YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void save() {
        if (this.config == null || this.file == null) {
            return;
        }
        try {
            this.getConfig().save(this.file);
        }
        catch (IOException ex) {
            Core.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + this.file, ex);
        }
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        if (this.file != null) {
            YamlConfiguration defSettingsConfig = YamlConfiguration.loadConfiguration((File)this.file);
            this.config.setDefaults((Configuration)defSettingsConfig);
        }
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reload();
        }
        return this.config;
    }

    public void createIfNotExist() {
        if (!Core.plugin.getDataFolder().exists()) {
            Core.plugin.getDataFolder().mkdir();
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not create " + this.fileName);
            }
        }
    }
}

