/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aldrigo.solidLogin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import net.sf.aldrigo.solidLogin.Messages;
import net.sf.aldrigo.solidLogin.PlayerListener;
import net.sf.aldrigo.solidLogin.commands.ChangePwdCommand;
import net.sf.aldrigo.solidLogin.commands.LoginCommand;
import net.sf.aldrigo.solidLogin.commands.RegisterCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SolidLogin
extends JavaPlugin {
    public static final HashMap<Player, Integer> NotLogged = new HashMap();
    private static HashMap<UUID, byte[]> registered;
    private File regFl;

    public static boolean isRegistered(Player p) {
        return registered.containsKey(p.getUniqueId());
    }

    public void onEnable() {
        if (!this.loadData()) {
            return;
        }
        this.getCommand("login").setExecutor((CommandExecutor)new LoginCommand(this));
        this.getCommand("register").setExecutor((CommandExecutor)new RegisterCommand(this));
        this.getCommand("changepwd").setExecutor((CommandExecutor)new ChangePwdCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener((Plugin)this), (Plugin)this);
        this.getLogger().info(ChatColor.GOLD + "v0.1.0 by Aldrigo R. ENABLED!" + ChatColor.RESET);
    }

    private boolean loadData() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        this.regFl = new File(this.getDataFolder().getPath() + File.separator + "registered.db");
        if (this.regFl.exists()) {
            try {
                FileInputStream fileIn = new FileInputStream(this.regFl);
                ObjectInputStream in = new ObjectInputStream(fileIn);
                registered = (HashMap)in.readObject();
                in.close();
                fileIn.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return true;
            }
            catch (ClassNotFoundException ex) {
                this.getLogger().warning(ChatColor.RED + "[SolidLogin] Class not found" + ChatColor.WHITE);
                ex.printStackTrace();
                return false;
            }
        } else {
            registered = new HashMap();
        }
        return true;
    }

    public void save() {
        try {
            FileOutputStream fileOut = new FileOutputStream(this.regFl);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(registered);
            out.close();
            fileOut.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public byte[] sha256(String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(text.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException ex) {
            this.getServer().getLogger().info(ex.getMessage());
            return null;
        }
    }

    public void onDisable() {
        this.save();
        this.getLogger().info("[SolidLogin] DISABLED!");
    }

    public boolean login(Player player, String password) {
        byte[] userPassHash = registered.get(player.getUniqueId());
        if (userPassHash == null) {
            Messages.PLAYER_NOT_REGISTERED.send((CommandSender)player, new Object[0]);
            return false;
        }
        if (!Arrays.equals(this.sha256(password), userPassHash)) {
            Messages.INVALID_LOGIN.send((CommandSender)player, new Object[0]);
            return false;
        }
        player.setWalkSpeed(0.2f);
        player.setFlySpeed(0.2f);
        NotLogged.remove(player);
        Messages.LOGIN_OK.send((CommandSender)player, new Object[0]);
        return true;
    }

    public void register(Player player, String password) {
        if (!registered.containsKey(player.getUniqueId())) {
            registered.put(player.getUniqueId(), this.sha256(password));
            player.sendMessage(ChatColor.GOLD + "[SolidLogin] You are now registered!" + ChatColor.WHITE);
            this.save();
        } else {
            player.sendMessage(ChatColor.RED + "[SolidLogin] You are already registered!" + ChatColor.WHITE);
        }
    }

    public void changePass(Player player, String password) {
        byte[] hashpass = this.sha256(password);
        registered.put(player.getUniqueId(), hashpass);
    }
}

