/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aldrigo.solidLogin;

import net.sf.aldrigo.solidLogin.SolidLogin;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class PlayerListener
implements Listener {
    private final Plugin plugin;

    public PlayerListener(Plugin p) {
        this.plugin = p;
    }

    public boolean isLoggedIn(Player p) {
        return !SolidLogin.NotLogged.containsKey(p);
    }

    private void sendNotLoggedMessage(Player p) {
        p.sendMessage(ChatColor.RED + "[SolidLogin] You are not logged in! You must login first!" + ChatColor.WHITE);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        player.setWalkSpeed(0.0f);
        player.setFlySpeed(0.0f);
        SolidLogin.NotLogged.put(player, 0);
        player.sendMessage(ChatColor.GOLD + "[SolidLogin] Welcome, you must login or register first. For additional help write /solidlogin" + ChatColor.WHITE);
        if (!SolidLogin.isRegistered(player)) {
            player.sendMessage(ChatColor.GOLD + "You must register first using /register <password> <password>" + ChatColor.WHITE);
        }
    }

    @EventHandler
    private void handleChat(AsyncPlayerChatEvent event) {
        if (event.getPlayer() == null || this.isLoggedIn(event.getPlayer())) {
            return;
        }
        event.setCancelled(true);
        this.sendNotLoggedMessage(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPlayerNormalChat(AsyncPlayerChatEvent event) {
        this.handleChat(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerHighChat(AsyncPlayerChatEvent event) {
        this.handleChat(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        this.handleChat(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerHighestChat(AsyncPlayerChatEvent event) {
        this.handleChat(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerEarlyChat(AsyncPlayerChatEvent event) {
        this.handleChat(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onPlayerLowChat(AsyncPlayerChatEvent event) {
        this.handleChat(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (this.isLoggedIn(event.getPlayer())) {
            return;
        }
        String cmd = event.getMessage().split(" ")[0].toLowerCase();
        if (!cmd.contains("login") && !cmd.contains("register")) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (event.getPlayer() != null && !this.isLoggedIn(event.getPlayer())) {
            SolidLogin.NotLogged.remove(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (event.getPlayer() != null && !this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getPlayer() != null && !this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPlayerConsumeItem(PlayerItemConsumeEvent event) {
        if (event.getPlayer() != null && !this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerInventoryOpen(InventoryOpenEvent event) {
        final Player player = (Player)event.getPlayer();
        if (!this.isLoggedIn(player)) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(player);
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.closeInventory();
                }
            }, 1L);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInventoryClick(InventoryClickEvent event) {
        Player player;
        if (event.getWhoClicked() != null && event.getWhoClicked() instanceof Player && !this.isLoggedIn(player = (Player)event.getWhoClicked())) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(player);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void playerHitPlayerEvent(EntityDamageByEntityEvent event) {
        Player player;
        Entity damager = event.getDamager();
        if (damager instanceof Player && !this.isLoggedIn(player = (Player)damager)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.getPlayer() != null && !this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        if (event.getPlayer() != null && !this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (event.getPlayer() != null && !this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (event.getPlayer() != null && !this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onSignChange(SignChangeEvent event) {
        if (event.getPlayer() != null && !this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity != null && entity instanceof Player && !this.isLoggedIn(player = (Player)entity)) {
            player.setFireTicks(0);
            event.setDamage(0.0);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityTarget(EntityTargetEvent event) {
        Player player;
        Entity entity = event.getTarget();
        if (entity != null && entity instanceof Player && !this.isLoggedIn(player = (Player)entity)) {
            event.setTarget(null);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onDmg(EntityDamageByEntityEvent event) {
        Player player;
        Entity entity = event.getDamager();
        if (entity != null && entity instanceof Player && !this.isLoggedIn(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        Player player;
        HumanEntity entity = event.getEntity();
        if (entity != null && entity instanceof Player && !this.isLoggedIn(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void entityRegainHealthEvent(EntityRegainHealthEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity != null && entity instanceof Player && !this.isLoggedIn(player = (Player)entity)) {
            event.setAmount(0.0);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityInteract(EntityInteractEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity != null && entity instanceof Player && !this.isLoggedIn(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onLowestEntityInteract(EntityInteractEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity != null && entity instanceof Player && !this.isLoggedIn(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        ProjectileSource shooter;
        Projectile projectile = event.getEntity();
        Player player = null;
        if (projectile != null && (shooter = projectile.getShooter()) != null && shooter instanceof Player && !this.isLoggedIn(player)) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(player);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onShoot(EntityShootBowEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity != null && entity instanceof Player && !this.isLoggedIn(player = (Player)entity)) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(player);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.getPlayer() != null && !this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getPlayer() != null && !this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
            this.sendNotLoggedMessage(event.getPlayer());
        }
    }
}

