/*
 * Decompiled with CFR 0.152.
 */
package me.gloomified.user.login;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import me.gloomified.user.login.ChangePwCommand;
import me.gloomified.user.login.Encrypt;
import me.gloomified.user.login.Events;
import me.gloomified.user.login.LoginCommand;
import me.gloomified.user.login.ReloadCommand;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Login
extends JavaPlugin
implements CommandExecutor {
    protected static ArrayList<Player> playersLoggedIn = new ArrayList();
    private static File file;
    private static FileConfiguration customFile;

    public void onEnable() {
        Login.setup();
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.getCommand("register").setExecutor((CommandExecutor)this);
        this.getCommand("login").setExecutor((CommandExecutor)new LoginCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        this.getCommand("LoginReload").setExecutor((CommandExecutor)new ReloadCommand());
        this.getCommand("changepw").setExecutor((CommandExecutor)new ChangePwCommand());
    }

    public void onDisable() {
    }

    protected static String translateToColorCode(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            switch (this.getConfig().getString("Encryption")) {
                case "AES": {
                    if (args.length != 1) break;
                    if (Login.get().get("Passwords." + ((Player)sender).getUniqueId()) == null) {
                        Player player = (Player)sender;
                        Encrypt.getEncryptClass().encrypt(args[0], player.getUniqueId(), Encrypt.EncryptType.AES);
                        player.sendMessage(Login.translateToColorCode(this.getConfig().get("Messages.Registered").toString()));
                        break;
                    }
                    sender.sendMessage(Login.translateToColorCode(this.getConfig().get("Messages.AlreadyRegistered").toString()));
                    break;
                }
                default: {
                    if (args.length != 1) break;
                    if (Login.get().get("Passwords." + ((Player)sender).getUniqueId()) == null) {
                        Player player = (Player)sender;
                        Encrypt.getEncryptClass().encrypt(args[0], player.getUniqueId(), Encrypt.EncryptType.ARGON2);
                        player.sendMessage(Login.translateToColorCode(this.getConfig().get("Messages.Registered").toString()));
                        break;
                    }
                    sender.sendMessage(Login.translateToColorCode(this.getConfig().get("Messages.AlreadyRegisterd").toString()));
                }
            }
        }
        return true;
    }

    public static void setup() {
        file = new File(Bukkit.getServer().getPluginManager().getPlugin("SimpleLogin").getDataFolder(), "data.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        customFile = YamlConfiguration.loadConfiguration((File)file);
    }

    public static FileConfiguration get() {
        return customFile;
    }

    public static void save() {
        try {
            customFile.save(file);
        }
        catch (IOException e) {
            System.out.println("Couldn't save file");
        }
    }

    public static void reload() {
        customFile = YamlConfiguration.loadConfiguration((File)file);
    }
}

