/*
 * Decompiled with CFR 0.152.
 */
package de.mavecrit.serverlogin;

import de.mavecrit.serverlogin.events.CloseInventory;
import de.mavecrit.serverlogin.events.Join;
import de.mavecrit.serverlogin.events.Leave;
import de.mavecrit.serverlogin.utils.SHA;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerLogin
extends JavaPlugin
implements Listener {
    public static Plugin plugin;
    static ServerLogin instance;
    public ArrayList<Player> started = new ArrayList();
    public ArrayList<UUID> authenticated = new ArrayList();

    public void loadConfiguration() {
        String player = "plugin.password";
        plugin.getConfig().addDefault(player, (Object)"9af15b336e6a9619928537df30b2e6a2376569fcf9d7e773eccede65606529a0");
        String onlinemode = "plugin.only_active_in_offline_mode";
        plugin.getConfig().addDefault(onlinemode, (Object)false);
        String kplayer = "plugin.keep-players-in-mind";
        plugin.getConfig().addDefault(kplayer, (Object)true);
        String rplayer = "plugin.keep-players-in-mind-on-restart";
        plugin.getConfig().addDefault(rplayer, (Object)true);
        String kicktime = "plugin.timeout";
        plugin.getConfig().addDefault(kicktime, (Object)30);
        String joinmes = "messages.joinmessage";
        plugin.getConfig().addDefault(joinmes, (Object)"&7You have &c{timeout} &7seconds to enter the password");
        String message = "messages.right";
        plugin.getConfig().addDefault(message, (Object)"&aCorrect!");
        String message2 = "messages.failed";
        plugin.getConfig().addDefault(message2, (Object)"&cWRONG PASSWORD");
        String title = "gui.title";
        plugin.getConfig().addDefault(title, (Object)"&7Enter password");
        String message3 = "gui.message.exit";
        plugin.getConfig().addDefault(message3, (Object)"&cClosing the login is not allowed");
        String timeout = "gui.message.timeout";
        plugin.getConfig().addDefault(timeout, (Object)"&cNo more time is left");
        String gui = "gui.itemhover";
        plugin.getConfig().addDefault(gui, (Object)"Enter password");
        plugin.getConfig().options().copyDefaults(true);
        plugin.saveConfig();
    }

    public void onEnable() {
        plugin = this;
        instance = this;
        this.loadConfiguration();
        if (ServerLogin.getPlugin().getConfig().get("plugin.password").toString().length() != 64) {
            Bukkit.getLogger().warning(ChatColor.RED + "PASSWORD NOT SHA256: Did you modify it in file? Thats a no no. Dont do that. No.");
            Bukkit.getLogger().info(ChatColor.GRAY + "Let me hash that for you..");
            String pw = ServerLogin.getPlugin().getConfig().get("plugin.password").toString();
            try {
                String hash = SHA.makeSHA1Hash(pw);
                ServerLogin.getPlugin().getConfig().set("plugin.password", (Object)hash);
                ServerLogin.getPlugin().saveConfig();
                Bukkit.getLogger().info(ChatColor.GREEN + "Password sha256 new checksum: " + hash);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (ServerLogin.getPlugin().getConfig().getBoolean("plugin.only_active_in_offline_mode") && Bukkit.getOnlineMode()) {
            Bukkit.getLogger().info(ChatColor.GOLD + "Plugin only operates in offline mode, server is online mode. Bravo going down. See ya!");
            Bukkit.getPluginManager().getPlugin("ServerLogin").onDisable();
            return;
        }
        if (ServerLogin.getPlugin().getConfig().getBoolean("plugin.keep-players-in-mind-on-restart")) {
            Bukkit.getLogger().info("Loading players into plugin core..");
            File playerFile = new File(ServerLogin.getPlugin().getDataFolder() + File.separator + "authenticated_players.yml");
            YamlConfiguration playerData = YamlConfiguration.loadConfiguration((File)playerFile);
            if (playerFile.exists()) {
                for (String suid : playerData.get("Users.uuid").toString().split(",")) {
                    UUID uuid = UUID.fromString(suid);
                    this.authenticated.add(uuid);
                }
            }
            Bukkit.getLogger().info("Loaded " + this.authenticated.size() + " players into plugin core");
        }
        this.registerListeners();
        Bukkit.getLogger().info("ServerLogin enabled");
    }

    public void onDisable() {
        Bukkit.getLogger().info("Saved players to file");
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static ServerLogin getInstance() {
        return instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String CommandLabel, String[] args) {
        Player player = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("serverlogin")) {
            if (player.hasPermission("serverlogin.admin")) {
                if (args.length == 0) {
                    player.sendMessage("\u00a77======== \u00a7cServerlogin \u00a77========");
                    player.sendMessage("\u00a77Developed by: \u00a7cMaveCrit");
                    player.sendMessage("\u00a77Commands:");
                    player.sendMessage("\u00a77/serverlogin password <password> - Set the password");
                    player.sendMessage("\u00a77/serverlogin delete <player> - Remove a player");
                    player.sendMessage("\u00a77/serverlogin reload - Reloads the config");
                    player.sendMessage("\u00a77You can edit the full plugin in the config.yml");
                    return false;
                }
                if (args[0] != null) {
                    if (args[0].equalsIgnoreCase("password")) {
                        if (args.length != 2) {
                            player.sendMessage("\u00a7cSyntax error: \u00a77/serverlogin password <password>");
                            return false;
                        }
                        try {
                            String sha = SHA.makeSHA1Hash(args[1]);
                            player.sendMessage("\u00a7aNew password: " + args[1]);
                            player.sendMessage("\u00a77SHA256 checksum: " + sha);
                            ServerLogin.getPlugin().getConfig().set("plugin.password", (Object)sha);
                            ServerLogin.getPlugin().saveConfig();
                        }
                        catch (NoSuchAlgorithmException e) {
                            e.printStackTrace();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    } else if (args[0].equalsIgnoreCase("delete")) {
                        if (args.length != 2) {
                            player.sendMessage("\u00a7cSyntax error: \u00a77/serverlogin delete <player>");
                            return false;
                        }
                        ServerLogin.getInstance().authenticated.remove(Bukkit.getPlayer((String)args[1]).getUniqueId());
                        if (ServerLogin.getPlugin().getConfig().getBoolean("plugin.keep-players-in-mind-on-restart")) {
                            Bukkit.getLogger().info("Loading players into plugin core..");
                            File playerFile = new File(ServerLogin.getPlugin().getDataFolder() + File.separator + "authenticated_players.yml");
                            YamlConfiguration playerData = YamlConfiguration.loadConfiguration((File)playerFile);
                            if (playerFile.exists() && playerData.getString("Users.uuid").contains(Bukkit.getPlayer((String)args[1]).getUniqueId().toString() + ",")) {
                                playerData.set("Users.uuid", (Object)playerData.getString("Users.uuid").replace(Bukkit.getPlayer((String)args[1]).getUniqueId().toString() + ",", ""));
                            }
                        }
                        player.sendMessage("\u00a7a" + args[1] + " \u00a77is now \u00a7cremoved from authenticated user list");
                    } else if (args[0].equalsIgnoreCase("reload") && args.length == 1) {
                        ServerLogin.getPlugin().saveConfig();
                        if (plugin.getConfig().get("plugin.password").toString().length() != 64) {
                            Bukkit.getLogger().warning("\u00a7cPASSWORD NOT SHA256: Did you modify it in file? Thats a no no. Dont do that. No.");
                            Bukkit.getLogger().info("\u00a7cLet me hash that for you..");
                            String pw = ServerLogin.getPlugin().getConfig().get("plugin.password").toString();
                            ServerLogin.getPlugin().saveConfig();
                            try {
                                String hash = SHA.makeSHA1Hash(pw);
                                ServerLogin.getPlugin().getConfig().set("plugin.password", (Object)hash);
                                Bukkit.getLogger().info("\u00a7aPassword sha256 new checksum: " + hash);
                                ServerLogin.getPlugin().saveConfig();
                            }
                            catch (NoSuchAlgorithmException e) {
                                e.printStackTrace();
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                        }
                        player.sendMessage("\u00a7aReloaded!");
                        plugin.reloadConfig();
                    }
                }
            }
        } else {
            player.sendMessage("\u00a77What did you expect to happen, huh?");
        }
        return false;
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Join(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CloseInventory(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Leave(), (Plugin)this);
    }
}

