/*
 * Decompiled with CFR 0.152.
 */
package me.bruno.login.manager;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import me.bruno.login.Main;
import me.bruno.login.manager.SpigetUpdateAbstract;
import me.bruno.login.manager.comparator.VersionComparator;
import me.bruno.login.manager.download.DownloadCallback;
import me.bruno.login.manager.download.UpdateDownloader;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigetUpdate
extends SpigetUpdateAbstract {
    protected final Plugin plugin;
    protected DownloadFailReason failReason = DownloadFailReason.UNKNOWN;

    public SpigetUpdate(Plugin plugin, int resourceId) {
        super(resourceId, plugin.getDescription().getVersion(), plugin.getLogger());
        this.plugin = plugin;
        this.setUserAgent("SpigetResourceUpdater/Bukkit");
    }

    @Override
    public SpigetUpdate setUserAgent(String userAgent) {
        super.setUserAgent(userAgent);
        return this;
    }

    @Override
    public SpigetUpdate setVersionComparator(VersionComparator comparator) {
        super.setVersionComparator(comparator);
        return this;
    }

    @Override
    protected void dispatch(Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, runnable);
    }

    public boolean downloadUpdate() {
        boolean allowExternalDownload;
        if (this.latestResourceInfo == null) {
            this.failReason = DownloadFailReason.NOT_CHECKED;
            return false;
        }
        if (!this.isVersionNewer(this.currentVersion, this.latestResourceInfo.latestVersion.name)) {
            this.failReason = DownloadFailReason.NO_UPDATE;
            return false;
        }
        if (this.latestResourceInfo.external) {
            this.failReason = DownloadFailReason.NO_DOWNLOAD;
            return false;
        }
        File pluginFile = this.getPluginFile();
        if (pluginFile == null) {
            this.failReason = DownloadFailReason.NO_PLUGIN_FILE;
            return false;
        }
        File updateFolder = Bukkit.getUpdateFolderFile();
        if (!updateFolder.exists() && !updateFolder.mkdirs()) {
            this.failReason = DownloadFailReason.NO_UPDATE_FOLDER;
            return false;
        }
        File updateFile = new File(updateFolder, pluginFile.getName());
        Properties properties = this.getUpdaterProperties();
        boolean bl = allowExternalDownload = properties != null && properties.containsKey("externalDownloads") && Boolean.valueOf(properties.getProperty("externalDownloads")) != false;
        if (!allowExternalDownload && this.latestResourceInfo.external) {
            this.failReason = DownloadFailReason.EXTERNAL_DISALLOWED;
            return false;
        }
        Bukkit.getConsoleSender().sendMessage(Main.getString("updater.process.downloading"));
        this.dispatch(UpdateDownloader.downloadAsync(this.latestResourceInfo, updateFile, this.getUserAgent(), new DownloadCallback(){

            @Override
            public void finished() {
                Bukkit.getConsoleSender().sendMessage(Main.getString("updater.success.updated").replace("%old-version%", Main.getPlugin().getDescription().getVersion()).replace("%new-version%", SpigetUpdate.this.getLatestResourceInfo().latestVersion.name.replace("v", "").replace("[", "").replace("]", "")));
            }

            @Override
            public void error(Exception exception) {
            }
        }));
        return true;
    }

    public DownloadFailReason getFailReason() {
        return this.failReason;
    }

    public Properties getUpdaterProperties() {
        File file = new File(Bukkit.getUpdateFolderFile(), "spiget.properties");
        Properties properties = new Properties();
        if (!file.exists()) {
            block6: {
                try {
                    if (file.createNewFile()) break block6;
                    return null;
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            properties.setProperty("externalDownloads", "false");
            properties.store(new FileWriter(file), "Configuration for the Spiget auto-updater. https://spiget.org | https://github.com/InventivetalentDev/SpigetUpdater\nUse 'externalDownloads' if you want to auto-download resources hosted on external sites\n");
        }
        try {
            properties.load(new FileReader(file));
        }
        catch (IOException e) {
            return null;
        }
        return properties;
    }

    private File getPluginFile() {
        if (!(this.plugin instanceof JavaPlugin)) {
            return null;
        }
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            method.setAccessible(true);
            return (File)method.invoke((Object)this.plugin, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not get plugin file", e);
        }
    }

    public static enum DownloadFailReason {
        NOT_CHECKED,
        NO_UPDATE,
        NO_DOWNLOAD,
        NO_PLUGIN_FILE,
        NO_UPDATE_FOLDER,
        EXTERNAL_DISALLOWED,
        UNKNOWN;

    }
}

