/*
 * Decompiled with CFR 0.152.
 */
package dev.wonkypigs.loginsystem.commands;

import dev.wonkypigs.loginsystem.LoginSystem;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SetpasswordCommand
implements CommandExecutor {
    private final LoginSystem plugin = (LoginSystem)LoginSystem.getPlugin(LoginSystem.class);

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            PersistentDataContainer pdata = player.getPersistentDataContainer();
            if (pdata.has(new NamespacedKey((Plugin)this.plugin, "password"), PersistentDataType.BYTE_ARRAY)) {
                player.sendMessage(this.plugin.prefix + ChatColor.GREEN + "You already have a password set.");
            } else if (args.length == 1) {
                SecureRandom random = new SecureRandom();
                byte[] salt = new byte[16];
                random.nextBytes(salt);
                MessageDigest md = null;
                try {
                    md = MessageDigest.getInstance("SHA-512");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                md.update(salt);
                byte[] hashedPassword = md.digest(args[0].getBytes(StandardCharsets.UTF_8));
                pdata.set(new NamespacedKey((Plugin)this.plugin, "password"), PersistentDataType.BYTE_ARRAY, (Object)hashedPassword);
                pdata.set(new NamespacedKey((Plugin)this.plugin, "password_salt"), PersistentDataType.BYTE_ARRAY, (Object)salt);
                player.sendMessage(this.plugin.prefix + ChatColor.GREEN + "Your password has been set to " + args[0]);
                pdata.set(new NamespacedKey((Plugin)this.plugin, "loggedin"), PersistentDataType.STRING, (Object)"yes");
            } else {
                player.sendMessage(this.plugin.prefix + ChatColor.GREEN + "Usage: '/setpassword <password>'");
            }
        } else {
            sender.sendMessage(this.plugin.prefix + ChatColor.RED + "Only players can use this command!");
        }
        return true;
    }
}

