/*
 * Decompiled with CFR 0.152.
 */
package dev.wonkypigs.loginsystem.commands;

import dev.wonkypigs.loginsystem.LoginSystem;
import dev.wonkypigs.loginsystem.commands.LoginCommand;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ChangepasswordCommand
implements CommandExecutor {
    private final LoginSystem plugin = (LoginSystem)LoginSystem.getPlugin(LoginSystem.class);

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            PersistentDataContainer pdata = player.getPersistentDataContainer();
            if (!pdata.has(new NamespacedKey((Plugin)this.plugin, "password"), PersistentDataType.BYTE_ARRAY)) {
                player.sendMessage(this.plugin.prefix + ChatColor.RED + "You do not have a password set. Type '/setpassword <password>' to set one.");
                return true;
            }
            if (!((String)pdata.get(new NamespacedKey((Plugin)this.plugin, "loggedin"), PersistentDataType.STRING)).equalsIgnoreCase("yes")) {
                player.sendMessage(this.plugin.prefix + ChatColor.RED + "You must be logged in to do that!");
                return true;
            }
            if (args.length == 2) {
                byte[] old_player_password;
                byte[] old_salt = (byte[])pdata.get(new NamespacedKey((Plugin)this.plugin, "password_salt"), PersistentDataType.BYTE_ARRAY);
                if (LoginCommand.checkPassword(old_salt, old_player_password = (byte[])pdata.get(new NamespacedKey((Plugin)this.plugin, "password"), PersistentDataType.BYTE_ARRAY), args[0])) {
                    SecureRandom random = new SecureRandom();
                    byte[] salt = new byte[16];
                    random.nextBytes(salt);
                    MessageDigest md = null;
                    try {
                        md = MessageDigest.getInstance("SHA-512");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                    md.update(salt);
                    byte[] hashedPassword = md.digest(args[0].getBytes(StandardCharsets.UTF_8));
                    pdata.set(new NamespacedKey((Plugin)this.plugin, "password"), PersistentDataType.BYTE_ARRAY, (Object)hashedPassword);
                    player.sendMessage(this.plugin.prefix + ChatColor.GREEN + "Your password has been changed to " + args[1]);
                } else {
                    player.sendMessage(this.plugin.prefix + ChatColor.RED + "Incorrect password.");
                }
            } else {
                player.sendMessage(this.plugin.prefix + ChatColor.GREEN + "Usage: '/changepassword <old_password> <new_password>'");
            }
        } else {
            sender.sendMessage(this.plugin.prefix + ChatColor.RED + "Only players can use this command!");
        }
        return true;
    }
}

