/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.util;

import com.lenis0012.bukkit.loginsecurity.storage.PlayerProfile;
import java.util.UUID;

public enum UserIdMode {
    UNKNOWN("U"),
    MOJANG("M"),
    OFFLINE("O");

    private final String id;

    private UserIdMode(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static UserIdMode fromId(String id) {
        for (UserIdMode mode : UserIdMode.values()) {
            if (!mode.id.equalsIgnoreCase(id)) continue;
            return mode;
        }
        return null;
    }

    public String getUserId(PlayerProfile profile) {
        if (profile.getUniqueIdMode() == this) {
            return profile.getUniqueUserId();
        }
        switch (this) {
            case OFFLINE: {
                return profile.getLastName() == null ? profile.getUniqueUserId() : UUID.nameUUIDFromBytes(("OfflinePlayer:" + profile.getLastName().toLowerCase()).getBytes()).toString();
            }
            case MOJANG: {
                return profile.getUniqueUserId();
            }
        }
        throw new IllegalStateException("Invalid uuid mode: " + this.toString());
    }
}

