/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.util;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerInventory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.logging.Level;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class InventorySerializer {
    public static PlayerInventory serializeInventory(org.bukkit.inventory.PlayerInventory inventory) {
        PlayerInventory entry = new PlayerInventory();
        entry.setHelmet(InventorySerializer.serialize(inventory.getHelmet()));
        entry.setChestplate(InventorySerializer.serialize(inventory.getChestplate()));
        entry.setLeggings(InventorySerializer.serialize(inventory.getLeggings()));
        entry.setBoots(InventorySerializer.serialize(inventory.getBoots()));
        entry.setContents(InventorySerializer.serialize(inventory.getContents()));
        return entry;
    }

    public static void deserializeInventory(PlayerInventory entry, org.bukkit.inventory.PlayerInventory inventory) {
        inventory.setHelmet((ItemStack)InventorySerializer.deserialize(entry.getHelmet()));
        inventory.setChestplate((ItemStack)InventorySerializer.deserialize(entry.getChestplate()));
        inventory.setLeggings((ItemStack)InventorySerializer.deserialize(entry.getLeggings()));
        inventory.setBoots((ItemStack)InventorySerializer.deserialize(entry.getBoots()));
        inventory.setContents((ItemStack[])InventorySerializer.deserialize(entry.getContents()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String serialize(Object item) {
        if (item == null) {
            return null;
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            BukkitObjectOutputStream output = new BukkitObjectOutputStream((OutputStream)baos);
            output.writeObject(item);
            String string = Base64.getEncoder().encodeToString(baos.toByteArray());
            return string;
        }
        catch (IOException e) {
            LoginSecurity.getInstance().getLogger().log(Level.SEVERE, "Failed to serialize item", e);
            String string = null;
            return string;
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserialize(String item) {
        if (item == null) {
            return null;
        }
        BukkitObjectInputStream input = null;
        try {
            byte[] bytes = Base64.getDecoder().decode(item);
            input = new BukkitObjectInputStream((InputStream)new ByteArrayInputStream(bytes));
            Object object = input.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            LoginSecurity.getInstance().getLogger().log(Level.SEVERE, "Failed to deserialize item", e);
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

