/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.session;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.events.AuthActionEvent;
import com.lenis0012.bukkit.loginsecurity.events.AuthModeChangedEvent;
import com.lenis0012.bukkit.loginsecurity.session.AuthAction;
import com.lenis0012.bukkit.loginsecurity.session.AuthMode;
import com.lenis0012.bukkit.loginsecurity.session.action.ActionCallback;
import com.lenis0012.bukkit.loginsecurity.session.action.ActionResponse;
import com.lenis0012.bukkit.loginsecurity.session.exceptions.ProfileRefreshException;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerProfile;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class PlayerSession {
    private PlayerProfile profile;
    private AuthMode mode;

    protected PlayerSession(PlayerProfile profile, AuthMode mode) {
        this.profile = profile;
        this.mode = mode;
    }

    public PlayerProfile getProfile() {
        return this.profile;
    }

    public void saveProfileAsync() {
        if (!this.isRegistered()) {
            throw new IllegalStateException("Can't save profile when not registered!");
        }
        LoginSecurity.getDatastore().getProfileRepository().update(this.profile, result -> {
            if (!result.success()) {
                LoginSecurity.getInstance().getLogger().log(Level.SEVERE, "Failed to save user profile", result.error());
            }
        });
    }

    public void refreshProfile() throws ProfileRefreshException {
        PlayerProfile newProfile;
        try {
            newProfile = LoginSecurity.getDatastore().getProfileRepository().findByUniqueUserIdBlocking(UUID.fromString(this.profile.getUniqueUserId()));
        }
        catch (SQLException e) {
            throw new ProfileRefreshException("Failed to load profile from database", e);
        }
        if (newProfile != null && !this.isRegistered()) {
            throw new ProfileRefreshException("Profile was registered while in database!");
        }
        if (newProfile == null && this.isRegistered()) {
            throw new ProfileRefreshException("Profile was not found, even though it should be there!");
        }
        if (newProfile == null) {
            return;
        }
        this.profile = newProfile;
    }

    public void resetProfile() {
        String lastName = this.profile.getLastName();
        this.profile = LoginSecurity.getSessionManager().createBlankProfile(UUID.fromString(this.profile.getUniqueUserId()));
        this.profile.setLastName(lastName);
    }

    public boolean isLoggedIn() {
        return this.isAuthorized() && this.profile.getPassword() != null;
    }

    public boolean isAuthorized() {
        return this.mode == AuthMode.AUTHENTICATED;
    }

    public boolean isRegistered() {
        return this.profile.getPassword() != null;
    }

    public AuthMode getAuthMode() {
        return this.mode;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((String)this.profile.getLastName());
    }

    public void performActionAsync(AuthAction action, ActionCallback callback) {
        LoginSecurity.getExecutorService().execute(() -> {
            ActionResponse response = this.performAction(action);
            Bukkit.getScheduler().runTask((Plugin)LoginSecurity.getInstance(), () -> callback.call(response));
        });
    }

    public ActionResponse performAction(AuthAction action) {
        AuthActionEvent event = new AuthActionEvent(this, action);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return new ActionResponse(false, event.getCancelledMessage());
        }
        ActionResponse response = new ActionResponse();
        AuthMode previous = this.mode;
        AuthMode current = action.run(this, response);
        if (current == null || !response.isSuccess()) {
            return response;
        }
        this.mode = current;
        if (previous != this.mode) {
            AuthModeChangedEvent event1 = new AuthModeChangedEvent(this, previous, this.mode);
            Bukkit.getPluginManager().callEvent((Event)event1);
        }
        return response;
    }
}

