/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.commands;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.LoginSecurityConfig;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.command.Command;
import com.lenis0012.bukkit.loginsecurity.modules.language.LanguageKeys;
import com.lenis0012.bukkit.loginsecurity.session.AuthService;
import com.lenis0012.bukkit.loginsecurity.session.PlayerSession;
import com.lenis0012.bukkit.loginsecurity.session.action.ActionCallback;
import com.lenis0012.bukkit.loginsecurity.session.action.ActionResponse;
import com.lenis0012.bukkit.loginsecurity.session.action.RegisterAction;
import optic_fusion1.loginsecurity.captcha.Captcha;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandRegister
extends Command {
    private final LoginSecurity plugin;

    public CommandRegister(LoginSecurity plugin) {
        this.plugin = plugin;
        this.setAllowConsole(false);
        if (plugin.config().isRegisterConfirmPassword()) {
            this.setMinArgs(2);
        } else {
            this.setMinArgs(1);
        }
    }

    @Override
    public void execute() {
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(this.player);
        String password = this.getArg(0);
        LoginSecurityConfig config = LoginSecurity.getConfiguration();
        if (password.length() < config.getPasswordMinLength() || password.length() > config.getPasswordMaxLength()) {
            this.reply(false, (Object)LoginSecurity.translate(LanguageKeys.GENERAL_PASSWORD_LENGTH).param("min", config.getPasswordMinLength()).param("max", config.getPasswordMaxLength()), new Object[0]);
            return;
        }
        if (session.isRegistered()) {
            this.reply(false, (Object)LoginSecurity.translate(LanguageKeys.REGISTER_ALREADY), new Object[0]);
            return;
        }
        if (config.isRegisterConfirmPassword() && !password.equals(this.getArg(1))) {
            this.reply(false, (Object)LoginSecurity.translate(LanguageKeys.ERROR_MATCH_PASSWORD), new Object[0]);
            return;
        }
        if (!config.isAllowUsernameAsPassword() && this.player.getName().equalsIgnoreCase(password)) {
            this.reply(false, (Object)LoginSecurity.translate(LanguageKeys.ERROR_PASSWORD_SAME_AS_USERNAME), new Object[0]);
            return;
        }
        if (config.isRegisterCaptcha()) {
            Captcha captcha = new Captcha(this.plugin, this.player.getUniqueId(), password, session);
            captcha.getGenerator().generateCaptcha(this.player);
            this.reply(true, (Object)LoginSecurity.translate(LanguageKeys.REGISTER_CAPTCHA), new Object[0]);
        } else {
            RegisterAction action = new RegisterAction(AuthService.PLAYER, this.player, password);
            session.performActionAsync(action, new RegisterCallback(this, this.player));
        }
    }

    private static final class RegisterCallback
    implements ActionCallback {
        private final CommandRegister command;
        private final Player player;

        private RegisterCallback(CommandRegister command, Player player) {
            this.command = command;
            this.player = player;
        }

        @Override
        public void call(ActionResponse response) {
            if (!response.isSuccess()) {
                this.command.reply((CommandSender)this.player, false, response.getErrorMessage(), new Object[0]);
                return;
            }
            this.command.reply((CommandSender)this.player, true, LoginSecurity.translate(LanguageKeys.REGISTER_SUCCESS), new Object[0]);
        }
    }
}

