/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.commands;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.LoginSecurityConfig;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.command.Command;
import com.lenis0012.bukkit.loginsecurity.modules.language.LanguageKeys;
import com.lenis0012.bukkit.loginsecurity.session.AuthService;
import com.lenis0012.bukkit.loginsecurity.session.PlayerSession;
import com.lenis0012.bukkit.loginsecurity.session.action.LogoutAction;
import org.bukkit.command.CommandSender;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CommandLogout
extends Command {
    private final LoginSecurity plugin;

    public CommandLogout(LoginSecurity plugin) {
        this.plugin = plugin;
        this.setAllowConsole(false);
    }

    @Override
    public void execute() {
        CommandLogout commandLogout = this;
        PlayerSession session = commandLogout.plugin.getSessionManager().getPlayerSession(this.player);
        if (!session.isLoggedIn()) {
            this.reply(false, (Object)LoginSecurity.translate(LanguageKeys.GENERAL_NOT_LOGGED_IN), new Object[0]);
            return;
        }
        LogoutAction action = new LogoutAction(AuthService.PLAYER, this.player);
        session.performActionAsync(action, response -> {
            if (!response.isSuccess()) {
                this.reply((CommandSender)this.player, false, (Object)LoginSecurity.translate(LanguageKeys.LOGOUT_FAIL).param("error", response.getErrorMessage()), new Object[0]);
                return;
            }
            this.reply((CommandSender)this.player, true, (Object)LoginSecurity.translate(LanguageKeys.LOGOUT_SUCCESS), new Object[0]);
            CommandLogout commandLogout = this;
            LoginSecurityConfig config = commandLogout.plugin.getConfiguration();
            if (config.isBlindness()) {
                this.player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, Integer.MAX_VALUE, 1));
            }
        });
    }
}

