/*
 * Decompiled with CFR 0.152.
 */
package optic_fusion1.loginsecurity.captcha;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.modules.language.LanguageKeys;
import com.lenis0012.bukkit.loginsecurity.session.AuthService;
import com.lenis0012.bukkit.loginsecurity.session.PlayerSession;
import com.lenis0012.bukkit.loginsecurity.session.action.RegisterAction;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import optic_fusion1.loginsecurity.captcha.CaptchaRenderer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class Captcha
implements Listener {
    private LoginSecurity loginSecurity;
    private UUID uniqueId;
    private PlayerSession session;
    private ItemStack mainHandItem;
    private Generator generator;
    private String password;

    public Captcha(LoginSecurity loginSecurity, UUID uniqueId, String password, PlayerSession session) {
        this.loginSecurity = loginSecurity;
        this.uniqueId = uniqueId;
        this.password = password;
        this.session = session;
        this.generator = new Generator();
        this.mainHandItem = Bukkit.getPlayer((UUID)uniqueId).getInventory().getItemInMainHand();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)loginSecurity);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void on(PlayerQuitEvent event) {
        Bukkit.getPlayer((UUID)this.uniqueId).getInventory().setItemInMainHand(this.mainHandItem);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void on(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (player.getUniqueId() != this.uniqueId) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (itemStack.getType() != Material.FILLED_MAP) {
            return;
        }
        event.setCancelled(true);
        if (!event.getMessage().trim().equals(this.generator.captcha)) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.loginSecurity, () -> player.kickPlayer("Wrong Captcha! Please try again."));
            return;
        }
        player.getInventory().setItemInMainHand(this.mainHandItem);
        RegisterAction action = new RegisterAction(AuthService.PLAYER, player, this.password);
        this.session.performAction(action);
        player.sendMessage(LoginSecurity.translate(LanguageKeys.REGISTER_SUCCESS).toString());
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public class Generator {
        String captcha;

        public void generateCaptcha(Player player) {
            this.captcha = this.randomCaptcha(5);
            MapView view = Bukkit.createMap((World)player.getWorld());
            view.getRenderers().clear();
            view.addRenderer((MapRenderer)new CaptchaRenderer(this.captcha));
            view.setCenterX(player.getLocation().getBlockX());
            view.setCenterZ(player.getLocation().getBlockZ());
            view.setScale(MapView.Scale.FARTHEST);
            ItemStack itemStack = new ItemStack(Material.FILLED_MAP);
            MapMeta itemMeta = (MapMeta)itemStack.getItemMeta();
            itemMeta.setMapView(view);
            itemMeta.setDisplayName("Captcha [Enter In Chat]");
            itemStack.setItemMeta((ItemMeta)itemMeta);
            player.getInventory().setItemInMainHand(itemStack);
            player.sendMap(view);
        }

        public String randomCaptcha(int length) {
            String sheet = "ABCDEFHIJKLMNOPQRSTUVWXYZ123456789";
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                builder.append("ABCDEFHIJKLMNOPQRSTUVWXYZ123456789".charAt(ThreadLocalRandom.current().nextInt("ABCDEFHIJKLMNOPQRSTUVWXYZ123456789".length())));
            }
            return builder.toString();
        }
    }
}

