/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.general;

import com.comphenix.protocol.metrics.Metrics;
import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.commands.CommandAdmin;
import com.lenis0012.bukkit.loginsecurity.commands.CommandChangePass;
import com.lenis0012.bukkit.loginsecurity.commands.CommandLogin;
import com.lenis0012.bukkit.loginsecurity.commands.CommandLogout;
import com.lenis0012.bukkit.loginsecurity.commands.CommandRegister;
import com.lenis0012.bukkit.loginsecurity.commands.CommandUnregister;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.Module;
import com.lenis0012.bukkit.loginsecurity.modules.general.InventoryPacketListener;
import com.lenis0012.bukkit.loginsecurity.modules.general.LocationMode;
import com.lenis0012.bukkit.loginsecurity.modules.general.PlayerListener;
import com.lenis0012.bukkit.loginsecurity.modules.language.LanguageModule;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GeneralModule
extends Module<LoginSecurity> {
    private LocationMode locationMode;

    public GeneralModule(LoginSecurity plugin) {
        super(plugin);
    }

    @Override
    public void enable() {
        this.registerCommands();
        this.registerListeners();
        this.setupMetrics();
        this.locationMode = LocationMode.valueOf(LoginSecurity.getConfiguration().getLocation().toUpperCase());
    }

    @Override
    public void disable() {
    }

    public LocationMode getLocationMode() {
        return this.locationMode;
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics((Plugin)this.plugin);
        metrics.addCustomChart((Metrics.CustomChart)new Metrics.SimplePie("language", () -> ((LoginSecurity)this.plugin).getModule(LanguageModule.class).getTranslation().getName()));
    }

    private void registerCommands() {
        this.logger().log(Level.INFO, "Registering commands...");
        this.register(new CommandLogin((LoginSecurity)this.plugin), "login");
        this.register(new CommandRegister((LoginSecurity)this.plugin), "register");
        this.register(new CommandChangePass((LoginSecurity)this.plugin), "changepassword");
        this.register(new CommandLogout((LoginSecurity)this.plugin), "logout");
        this.register(new CommandUnregister((LoginSecurity)this.plugin), "unregister");
        this.register(new CommandAdmin((LoginSecurity)this.plugin), "lac");
    }

    private void registerListeners() {
        this.logger().log(Level.INFO, "Registering listeners...");
        this.register(new PlayerListener(this));
        if (Bukkit.getPluginManager().isPluginEnabled("ProtocolLib")) {
            InventoryPacketListener.register((Plugin)this.plugin);
        }
    }

    private File getPluginFile() {
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            method.setAccessible(true);
            return (File)method.invoke((Object)this.plugin, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't get plugin file", e);
        }
    }
}

