/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.database;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.database.AsyncResult;
import com.lenis0012.bukkit.loginsecurity.database.SQLConsumer;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerLocation;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerProfile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class LocationRepository {
    private final LoginSecurity loginSecurity;
    private final DataSource dataSource;

    public LocationRepository(LoginSecurity loginSecurity, DataSource dataSource) {
        this.loginSecurity = loginSecurity;
        this.dataSource = dataSource;
    }

    public void insertLoginLocation(PlayerProfile profile, PlayerLocation location, Consumer<AsyncResult<PlayerLocation>> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.loginSecurity, () -> {
            try {
                this.insertLoginLocationBlocking(profile, location);
                this.resolveResult(callback, location);
            }
            catch (SQLException e) {
                this.resolveError(callback, e);
            }
        });
    }

    public void insertLoginLocationBlocking(PlayerProfile profile, PlayerLocation location) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            try (PreparedStatement statement = connection.prepareStatement("INSERT INTO ls_locations(world, x, y, z, yaw, pitch) VALUES (?,?,?,?,?,?);", 1);){
                this.prepareInsert(statement, location);
                statement.executeUpdate();
                try (ResultSet keys = statement.getGeneratedKeys();){
                    if (!keys.next()) {
                        throw new SQLException("Could not get ID for new location");
                    }
                    location.setId(keys.getInt(1));
                }
            }
            profile.setLoginLocationId(location.getId());
            statement = connection.prepareStatement("UPDATE ls_players SET location_id=? WHERE id=?;");
            try {
                statement.setInt(1, location.getId());
                statement.setInt(2, profile.getId());
                if (statement.executeUpdate() < 1) {
                    this.loginSecurity.getLogger().log(Level.WARNING, "Failed to set inventory id in profile");
                    throw new SQLException("Failed set location id in profile");
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    public void findById(int id, Consumer<AsyncResult<PlayerLocation>> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.loginSecurity, () -> {
            try {
                PlayerLocation location = this.findByIdBlocking(id);
                this.resolveResult(callback, location);
            }
            catch (SQLException e) {
                this.resolveError(callback, e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public PlayerLocation findByIdBlocking(int id) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void iterateAllBlocking(SQLConsumer<PlayerLocation> consumer) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet result = statement.executeQuery("SELECT * FROM ls_locations;");){
            while (result.next()) {
                consumer.accept(this.parseResultSet(result));
            }
        }
    }

    public void batchInsert(SQLConsumer<SQLConsumer<PlayerLocation>> callback) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO ls_locations(world, x, y, z, yaw, pitch) VALUES (?,?,?,?,?,?);");){
            AtomicInteger currentBatchSize = new AtomicInteger();
            callback.accept(location -> {
                this.prepareInsert(statement, (PlayerLocation)location);
                statement.addBatch();
                if (currentBatchSize.incrementAndGet() >= 1000) {
                    statement.executeBatch();
                    currentBatchSize.set(0);
                }
            });
            if (currentBatchSize.get() > 0) {
                statement.executeBatch();
            }
        }
    }

    private PlayerLocation parseResultSet(ResultSet result) throws SQLException {
        PlayerLocation location = new PlayerLocation();
        location.setId(result.getInt("id"));
        location.setWorld(result.getString("world"));
        location.setX(result.getDouble("x"));
        location.setY(result.getDouble("y"));
        location.setZ(result.getDouble("z"));
        location.setYaw(result.getInt("yaw"));
        location.setPitch(result.getInt("pitch"));
        return location;
    }

    private void prepareInsert(PreparedStatement statement, PlayerLocation location) throws SQLException {
        statement.setString(1, location.getWorld());
        statement.setDouble(2, location.getX());
        statement.setDouble(3, location.getY());
        statement.setDouble(4, location.getZ());
        statement.setInt(5, location.getYaw());
        statement.setInt(6, location.getPitch());
    }

    private <T> void resolveResult(Consumer<AsyncResult<T>> callback, T result) {
        Bukkit.getScheduler().runTask((Plugin)this.loginSecurity, () -> callback.accept(new AsyncResult<Object>(true, result, null)));
    }

    private <T> void resolveError(Consumer<AsyncResult<T>> callback, Exception error) {
        Bukkit.getScheduler().runTask((Plugin)this.loginSecurity, () -> callback.accept(new AsyncResult<Object>(false, null, error)));
    }
}

