/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;

public class ReflectionBuilder {
    private final Class<?> clazz;
    private final Object instance;

    public ReflectionBuilder(String className) {
        this.clazz = Class.forName(className);
        this.instance = this.clazz.newInstance();
    }

    public ReflectionBuilder call(String methodName, Object ... args) {
        Optional<Method> matchingMethod = Arrays.stream(this.clazz.getMethods()).filter(method -> method.getName().equals(methodName)).filter(method -> method.getParameterCount() == args.length).filter(method -> ReflectionBuilder.methodSignatureMatches(method, args)).findFirst();
        matchingMethod.get().invoke(this.instance, args);
        return this;
    }

    public Object build() {
        return this.instance;
    }

    public <T> T build(Class<T> type) {
        return type.cast(this.instance);
    }

    private static boolean methodSignatureMatches(Method method, Object[] args) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

