/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.storage;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.database.LoginSecurityDatabase;
import com.lenis0012.bukkit.loginsecurity.database.datasource.SingleConnectionDataSource;
import com.lenis0012.bukkit.loginsecurity.database.datasource.sqlite.SQLiteConnectionPoolDataSource;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.Module;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration.Configuration;
import com.lenis0012.bukkit.loginsecurity.modules.storage.MigrationRunner;
import com.lenis0012.bukkit.loginsecurity.util.ReflectionBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class NewStorageModule
extends Module<LoginSecurity> {
    private SingleConnectionDataSource dataSource;
    private LoginSecurityDatabase database;
    private String platform;

    public NewStorageModule(LoginSecurity plugin) {
        super(plugin);
    }

    @Override
    public void enable() {
        ConnectionPoolDataSource dataSourceConfig;
        File configFile = new File(((LoginSecurity)this.plugin).getDataFolder(), "database.yml");
        if (!configFile.exists()) {
            this.copyFile(((LoginSecurity)this.plugin).getResource("database.yml"), configFile);
        }
        Configuration config = new Configuration(configFile);
        config.reload();
        if (config.getBoolean("mysql.enabled")) {
            this.platform = "mysql";
            dataSourceConfig = this.createMysqlDataSource(config);
        } else {
            this.platform = "sqlite";
            dataSourceConfig = this.createSqliteDataSource();
        }
        this.dataSource = new SingleConnectionDataSource((Plugin)this.plugin, dataSourceConfig);
        this.database = new LoginSecurityDatabase((LoginSecurity)this.plugin, this.dataSource);
        try {
            this.dataSource.createConnection();
            new MigrationRunner((LoginSecurity)this.plugin, this.dataSource, this.platform).run();
        }
        catch (SQLException e) {
            ((LoginSecurity)this.plugin).getLogger().log(Level.SEVERE, "Failed to initiate database", e);
        }
    }

    @Override
    public void disable() {
        try {
            this.dataSource.shutdown();
        }
        catch (SQLException e) {
            Bukkit.getLogger().log(Level.WARNING, "Failed to shut down database", e);
        }
    }

    ConnectionPoolDataSource createMysqlDataSource(Configuration config) {
        if (ReflectionBuilder.classExists("com.mysql.cj.jdbc.MysqlConnectionPoolDataSource")) {
            return this.createMysqlDataSourceCJ(config);
        }
        if (ReflectionBuilder.classExists("com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource")) {
            return this.createMysqlDataSourceOld(config);
        }
        throw new IllegalStateException("Failed to create MySQL data source (no compatible driver found)");
    }

    private ConnectionPoolDataSource createMysqlDataSourceCJ(Configuration config) {
        return new ReflectionBuilder("com.mysql.cj.jdbc.MysqlConnectionPoolDataSource").call("setUrl", "jdbc:mysql://" + config.getString("mysql.host") + "/" + config.getString("mysql.database")).call("setUser", config.getString("mysql.username")).call("setPassword", config.getString("mysql.password")).build(ConnectionPoolDataSource.class);
    }

    private ConnectionPoolDataSource createMysqlDataSourceOld(Configuration config) {
        return new ReflectionBuilder("com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource").call("setUrl", "jdbc:mysql://" + config.getString("mysql.host") + "/" + config.getString("mysql.database")).call("setUser", config.getString("mysql.username")).call("setPassword", config.getString("mysql.password")).build(ConnectionPoolDataSource.class);
    }

    ConnectionPoolDataSource createSqliteDataSource() {
        File backupFile = new File(((LoginSecurity)this.plugin).getDataFolder(), "LoginSecurity.db.3.0.backup");
        if (!backupFile.exists()) {
            try {
                this.copyFile(new FileInputStream(new File(((LoginSecurity)this.plugin).getDataFolder(), "LoginSecurity.db")), backupFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        SQLiteConnectionPoolDataSource sqliteConfig = new SQLiteConnectionPoolDataSource();
        String path = new File(((LoginSecurity)this.plugin).getDataFolder(), "LoginSecurity.db").getPath();
        sqliteConfig.setUrl("jdbc:sqlite:" + path);
        return sqliteConfig;
    }

    public LoginSecurityDatabase getDatabase() {
        return this.database;
    }

    private void copyFile(InputStream from, File to) {
        try {
            int length;
            FileOutputStream output = new FileOutputStream(to);
            byte[] buffer = new byte[1024];
            while ((length = from.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            output.close();
            from.close();
        }
        catch (IOException e) {
            ((LoginSecurity)this.plugin).getLogger().log(Level.WARNING, "Failed to copy resource", e);
        }
    }

    public String getPlatform() {
        return this.platform;
    }
}

