/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.libs.updater.api;

import com.lenis0012.bukkit.loginsecurity.libs.updater.api.Updater;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class UpdaterFactory {
    private static final String PACKAGE_BASE = "com.lenis0012.bukkit.loginsecurity.libs.updater";
    private static final String PACKAGE_BUKKIT = ".bukkit.BukkitUpdater";
    private static final String PACKAGE_SPIGOT = ".spigot.SpigotUpdater";
    private final Plugin plugin;
    private String updaterInfo;
    private Class<?> updaterClass;

    public UpdaterFactory(Plugin plugin) {
        this(plugin, PACKAGE_BASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdaterFactory(Plugin plugin, String packageBase) {
        this.plugin = plugin;
        List<String> platforms = Arrays.asList(PACKAGE_BUKKIT, PACKAGE_SPIGOT);
        for (String platform : platforms) {
            this.updaterClass = this.classExists(packageBase + platform);
            if (this.updaterClass == null) continue;
            break;
        }
        if (this.updaterClass == null) {
            plugin.getLogger().log(Level.WARNING, "No compatible updater was founds for your platform!");
            plugin.getLogger().log(Level.INFO, "Plugin will not check for updates");
            return;
        }
        InputStream input = plugin.getResource("updater.txt");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(input));
            this.updaterInfo = reader.readLine();
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Failed to read updater info from updater.txt");
            plugin.getLogger().log(Level.INFO, "Plugin will not check for updates");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Class<?> classExists(String path) {
        try {
            return Class.forName(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Updater newUpdater(File pluginFile, boolean enabled) {
        if (this.updaterClass == null || this.updaterInfo == null) {
            return null;
        }
        try {
            return (Updater)this.updaterClass.getConstructor(Plugin.class, File.class, String.class, Boolean.TYPE).newInstance(this.plugin, pluginFile, this.updaterInfo, enabled);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Couldn't initiate updater", e);
            return null;
        }
    }
}

