/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.ls.data;

import com.google.common.base.Charsets;
import com.lenis0012.bukkit.ls.LoginSecurity;
import com.lenis0012.bukkit.ls.data.DataManager;
import com.lenis0012.bukkit.ls.data.MySQL;
import com.lenis0012.bukkit.ls.data.SQLite;
import com.lenis0012.bukkit.ls.util.SpigotUtil;
import com.lenis0012.bukkit.ls.util.UUIDFetcher;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UUIDConverter {
    public static boolean IS_CONVERTING = false;
    private final boolean isUsingSQLite;
    private final DataManager database;
    private final Logger logger;
    private final String table;

    public UUIDConverter(DataManager database, Logger logger, String table) {
        this.isUsingSQLite = database instanceof SQLite;
        this.database = database;
        this.logger = logger;
        this.table = table;
    }

    public void convert() {
        try {
            DatabaseMetaData md = this.database.getConnection().getMetaData();
            ResultSet rs = md.getColumns(null, null, this.table, "username");
            if (rs.next()) {
                this.logger.log(Level.INFO, "Username column was detected, conversion to UUID will begin in 20 seconds.");
                this.logger.log(Level.INFO, "This can not be reversed, stop the server NOW if you don't want this.");
                IS_CONVERTING = true;
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)LoginSecurity.instance, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HashMap<String, UUID> uuids;
                            ArrayList<Object[]> loginData;
                            block14: {
                                UUIDConverter.this.logger.log(Level.INFO, "Conversion to UUID has started, this may take some time");
                                ArrayList<String> usernames = new ArrayList<String>();
                                loginData = new ArrayList<Object[]>();
                                PreparedStatement ps = UUIDConverter.this.database.getConnection().prepareStatement("SELECT * FROM " + UUIDConverter.this.table);
                                ResultSet result = ps.executeQuery();
                                while (result.next()) {
                                    Object[] data = new Object[]{result.getString("username"), result.getString("password"), result.getInt("encryption"), result.getString("ip")};
                                    loginData.add(data);
                                }
                                UUIDConverter.this.logger.log(Level.INFO, "Loaded " + loginData.size() + " columns, starting to convert usernames to uuid");
                                UUIDFetcher fetcher = new UUIDFetcher(usernames);
                                try {
                                    if (Bukkit.getOnlineMode()) {
                                        uuids = fetcher.call();
                                        break block14;
                                    }
                                    boolean bungee = false;
                                    try {
                                        Class.forName("org.spigotmc.SpigotConfig");
                                        bungee = SpigotUtil.isBungee();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (bungee) {
                                        UUIDConverter.this.logger.log(Level.INFO, "Bungeecord-mode detected. uuids will be converted with online-mode");
                                        uuids = fetcher.call();
                                    } else {
                                        UUIDConverter.this.logger.log(Level.INFO, "Offline-mode detected. uuids will be converted locally");
                                        uuids = new HashMap<String, UUID>();
                                        for (String name : usernames) {
                                            uuids.put(name, UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)));
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    UUIDConverter.this.logger.log(Level.SEVERE, "Failed to convert uuids", e);
                                    return;
                                }
                            }
                            if (UUIDConverter.this.isUsingSQLite) {
                                UUIDConverter.this.database.closeConnection();
                                UUIDConverter.this.database.openConnection();
                                UUIDConverter.this.database.getConnection().createStatement().executeUpdate("DROP TABLE users;");
                            } else {
                                ((MySQL)UUIDConverter.this.database).dropTable(UUIDConverter.this.table);
                            }
                            UUIDConverter.this.database.closeConnection();
                            UUIDConverter.this.database.openConnection();
                            for (Object[] data : loginData) {
                                String uuid = ((UUID)uuids.get((String)data[0])).toString().replaceAll("-", "");
                                UUIDConverter.this.database.register(uuid, (String)data[1], (Integer)data[2], (String)data[3]);
                            }
                            UUIDConverter.this.logger.log(Level.INFO, "Conversion completed.");
                            IS_CONVERTING = false;
                        }
                        catch (SQLException e) {
                            UUIDConverter.this.logger.log(Level.SEVERE, "Failed to convert to uuid, this is bad.");
                        }
                    }
                }, 400L);
            }
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "Failed to check if username column exists");
        }
    }
}

