/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.ls;

import com.lenis0012.bukkit.ls.CommandFilter;
import com.lenis0012.bukkit.ls.LoginListener;
import com.lenis0012.bukkit.ls.ThreadManager;
import com.lenis0012.bukkit.ls.commands.AdminCommand;
import com.lenis0012.bukkit.ls.commands.ChangePassCommand;
import com.lenis0012.bukkit.ls.commands.LoginCommand;
import com.lenis0012.bukkit.ls.commands.LogoutCommand;
import com.lenis0012.bukkit.ls.commands.RegisterCommand;
import com.lenis0012.bukkit.ls.commands.RmPassCommand;
import com.lenis0012.bukkit.ls.data.Converter;
import com.lenis0012.bukkit.ls.data.DataManager;
import com.lenis0012.bukkit.ls.data.MySQL;
import com.lenis0012.bukkit.ls.data.SQLite;
import com.lenis0012.bukkit.ls.encryption.EncryptionType;
import com.lenis0012.bukkit.ls.util.Metrics;
import com.lenis0012.bukkit.ls.util.Updater;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class LoginSecurity
extends JavaPlugin {
    public DataManager data;
    public static LoginSecurity instance;
    public Map<String, Boolean> authList = new HashMap<String, Boolean>();
    public Map<String, Location> loginLocations = new HashMap<String, Location>();
    public List<String> messaging = new ArrayList<String>();
    public boolean required;
    public boolean blindness;
    public boolean sesUse;
    public boolean timeUse;
    public boolean spawntp;
    public int sesDelay;
    public int timeDelay;
    public static final Logger log;
    public ThreadManager thread;
    public String prefix;
    public EncryptionType hasher;
    public Map<String, CommandExecutor> commandMap = new HashMap<String, CommandExecutor>();
    public static int PHP_VERSION;
    public static String encoder;
    private static Logger serverLog;
    private CommandFilter commandFilter = new CommandFilter();
    private Updater updater;

    static {
        log = Logger.getLogger("Minecraft");
    }

    public void onEnable() {
        FileConfiguration config = this.getConfig();
        PluginManager pm = this.getServer().getPluginManager();
        config.addDefault("settings.password-required", (Object)false);
        config.addDefault("settings.encryption", (Object)"BCRYPT");
        config.addDefault("settings.encoder", (Object)"UTF-8");
        config.addDefault("settings.PHP_VERSION", (Object)4);
        config.addDefault("settings.messager-api", (Object)true);
        config.addDefault("settings.blindness", (Object)true);
        config.addDefault("settings.fake-location", (Object)false);
        config.addDefault("settings.session.use", (Object)true);
        config.addDefault("settings.session.timeout (sec)", (Object)60);
        config.addDefault("settings.timeout.use", (Object)true);
        config.addDefault("settings.timeout.timeout (sec)", (Object)60);
        config.addDefault("settings.table prefix", (Object)"ls_");
        config.addDefault("settings.update-checker", (Object)true);
        config.addDefault("MySQL.use", (Object)false);
        config.addDefault("MySQL.host", (Object)"localhost");
        config.addDefault("MySQL.port", (Object)3306);
        config.addDefault("MySQL.database", (Object)"LoginSecurity");
        config.addDefault("MySQL.username", (Object)"root");
        config.addDefault("MySQL.password", (Object)"password");
        config.addDefault("MySQL.prefix", (Object)"");
        config.options().copyDefaults(true);
        this.saveConfig();
        instance = (LoginSecurity)pm.getPlugin("LoginSecurity");
        this.prefix = config.getString("settings.table prefix");
        this.data = this.getDataManager(config, "users.db");
        this.thread = new ThreadManager(this);
        this.thread.startMsgTask();
        this.required = config.getBoolean("settings.password-required");
        this.blindness = config.getBoolean("settings.blindness");
        this.spawntp = config.getBoolean("settings.fake-location");
        this.sesUse = config.getBoolean("settings.session.use", true);
        this.sesDelay = config.getInt("settings.session.timeout (sec)", 60);
        this.timeUse = config.getBoolean("settings.timeout.use", true);
        this.timeDelay = config.getInt("settings.timeout.timeout (sec)", 60);
        PHP_VERSION = config.getInt("settings.PHP_VERSION", 4);
        this.hasher = EncryptionType.fromString(config.getString("settings.encryption"));
        String enc = config.getString("settings.encoder");
        encoder = enc.equalsIgnoreCase("utf-16") ? "UTF-16" : "UTF-8";
        if (this.sesUse) {
            this.thread.startSessionTask();
        }
        if (this.timeUse) {
            this.thread.startTimeoutTask();
        }
        if (config.getBoolean("settings.update-checker")) {
            this.updater = new Updater((Plugin)this, 41702, this.getFile(), Updater.UpdateType.NO_DOWNLOAD, true);
        }
        this.thread.startMainTask();
        this.thread.startMsgTask();
        this.checkConverter();
        pm.registerEvents((Listener)new LoginListener(this), (Plugin)this);
        this.registerCommands();
        if (config.contains("options")) {
            config.set("options", null);
            this.saveConfig();
        }
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (Exception e) {
            log.info("[LoginSecurity] Failed sending stats to mcstats.org");
        }
        serverLog = this.getServer().getLogger();
        this.commandFilter.prevFilter = log.getFilter();
        serverLog.setFilter(this.commandFilter);
        try {
            this.authList = this.loadAuthList();
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "[LoginSecurity] Could not read from auth list!");
        }
        catch (ClassNotFoundException ex) {
            log.log(Level.SEVERE, "[LoginSecurity] Could not read from auth list (bad data)!");
        }
    }

    public void onDisable() {
        if (this.data != null) {
            this.data.closeConnection();
        }
        if (this.thread != null) {
            this.thread.stopMsgTask();
            this.thread.stopSessionTask();
        }
        serverLog.setFilter(this.commandFilter.prevFilter);
        this.commandFilter.prevFilter = null;
        try {
            this.saveAuthList(this.authList);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "[LoginSecurity] Could not save to auth list (check permissions?)");
        }
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public void saveAuthList(Map<String, Boolean> map) throws IOException {
        File file = new File(this.getDataFolder(), "authList");
        FileOutputStream fout = new FileOutputStream(file);
        ObjectOutputStream out = new ObjectOutputStream(fout);
        out.writeObject(map);
        out.close();
        fout.close();
    }

    public Map<String, Boolean> loadAuthList() throws IOException, ClassNotFoundException {
        File file = new File(this.getDataFolder(), "authList");
        FileInputStream fin = new FileInputStream(file);
        ObjectInputStream in = new ObjectInputStream(fin);
        HashMap map = (HashMap)in.readObject();
        in.close();
        file.delete();
        fin.close();
        return map;
    }

    private DataManager getDataManager(FileConfiguration config, String fileName) {
        if (config.getBoolean("MySQL.use")) {
            return new MySQL(config, String.valueOf(this.getConfig().getString("MySQL.prefix", "")) + "users");
        }
        return new SQLite(new File(this.getDataFolder(), fileName));
    }

    private void checkConverter() {
        Plugin xAuth;
        Converter conv;
        MySQL mysql;
        Converter conv2;
        PluginManager pm = this.getServer().getPluginManager();
        File file = new File(this.getDataFolder(), "data.yml");
        if (file.exists()) {
            conv2 = new Converter(Converter.FileType.YAML, file);
            conv2.convert();
        }
        if ((file = new File(this.getDataFolder(), "data.db")).exists() && this.data instanceof MySQL) {
            conv2 = new Converter(Converter.FileType.SQLite, file);
            conv2.convert();
        }
        if (this.data instanceof MySQL && (mysql = (MySQL)this.data).tableExists("passwords")) {
            conv = new Converter(Converter.FileType.OldToNewMySQL, null);
            conv.convert();
        }
        if ((xAuth = pm.getPlugin("xAuth")) != null && xAuth.isEnabled()) {
            conv = new Converter(Converter.FileType.xAuth, null);
            conv.convert();
            log.info("[LoginSecurity] Converted data from xAuth to LoginSecurity");
        }
    }

    public void registerCommands() {
        this.commandMap.clear();
        this.commandMap.put("login", new LoginCommand());
        this.commandMap.put("register", new RegisterCommand());
        this.commandMap.put("changepass", new ChangePassCommand());
        this.commandMap.put("rmpass", new RmPassCommand());
        this.commandMap.put("logout", new LogoutCommand());
        this.commandMap.put("lac", new AdminCommand());
        for (Map.Entry<String, CommandExecutor> entry : this.commandMap.entrySet()) {
            String cmd = entry.getKey();
            CommandExecutor ex = entry.getValue();
            this.getCommand(cmd).setExecutor(ex);
        }
    }

    public boolean checkLastIp(Player player) {
        String uuid = player.getUniqueId().toString().replaceAll("-", "");
        if (this.data.isRegistered(uuid)) {
            String lastIp = this.data.getIp(uuid);
            String currentIp = player.getAddress().getAddress().toString();
            return lastIp.equalsIgnoreCase(currentIp);
        }
        return false;
    }

    public void playerJoinPrompt(Player player) {
        String uuid = player.getUniqueId().toString().replaceAll("-", "");
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (player != p && player.getName().equalsIgnoreCase(p.getName())) {
                player.kickPlayer("You are already logged in under the name: " + p.getName());
                return;
            }
            ++n2;
        }
        if (this.sesUse && this.thread.getSession().containsKey(uuid) && this.checkLastIp(player)) {
            player.sendMessage(ChatColor.GREEN + "Extended session from last login");
            return;
        }
        if (this.data.isRegistered(uuid)) {
            this.authList.put(player.getName().toLowerCase(), false);
            player.sendMessage(ChatColor.RED + "Por favor usa el comando /login <password>");
        } else if (this.required) {
            this.authList.put(player.getName().toLowerCase(), true);
            player.sendMessage(ChatColor.RED + "Por favor usa el comando /register <password>");
        } else {
            return;
        }
        this.debilitatePlayer(player, player.getName().toLowerCase(), false);
    }

    public void debilitatePlayer(Player player, String name, boolean logout) {
        if (this.timeUse) {
            this.thread.Tiempo de espera excedido.put(name, this.timeDelay);
        }
        if (this.blindness) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 1728000, 15));
        }
        if (this.spawntp && !logout) {
            this.loginLocations.put(name, player.getLocation().clone());
            player.teleport(player.getWorld().getSpawnLocation());
        }
    }

    public void rehabPlayer(Player player, String name) {
        player.removePotionEffect(PotionEffectType.BLINDNESS);
        if (this.spawntp && this.loginLocations.containsKey(name)) {
            Location fixedLocation = this.loginLocations.remove(name);
            fixedLocation.add(0.0, 0.2, 0.0);
            player.teleport(fixedLocation);
        }
        player.setRemainingAir(player.getMaximumAir());
    }
}

