/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.ls;

import com.lenis0012.bukkit.ls.LoginSecurity;
import com.lenis0012.bukkit.ls.data.UUIDConverter;
import com.lenis0012.bukkit.ls.util.StringUtil;
import com.lenis0012.bukkit.ls.util.Updater;
import org.apache.commons.lang.RandomStringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class LoginListener
implements Listener {
    private LoginSecurity plugin;

    public LoginListener(LoginSecurity i) {
        this.plugin = i;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        if (UUIDConverter.IS_CONVERTING) {
            player.kickPlayer("The server is currently converting all login data, please join back later.");
            return;
        }
        if (!player.getName().equals(StringUtil.cleanString(player.getName()))) {
            player.kickPlayer("Invalid characters in username!");
            return;
        }
        this.plugin.playerJoinPrompt(player);
        if (player.hasPermission("ls.admin")) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Updater updater = LoginListener.this.plugin.getUpdater();
                    if (updater != null && updater.getResult() == Updater.UpdateResult.UPDATE_AVAILABLE) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)String.format("&aA new &7%s &7build for LoginSecurtiy was found, you can get &7%s &afor &7%s &aon BukkitDev!", updater.getLatestType().toString().toLowerCase(), updater.getLatestName(), updater.getLatestGameVersion())));
                    }
                }
            }, 20L);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        String name = event.getName().toLowerCase();
        Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            String pname = player.getName().toLowerCase();
            if (!this.plugin.authList.containsKey(pname) && pname.equalsIgnoreCase(name)) {
                event.setResult(PlayerPreLoginEvent.Result.KICK_OTHER);
                event.setKickMessage("A player with this name is already online!");
            }
            ++n2;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (UUIDConverter.IS_CONVERTING) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        String uuid = player.getUniqueId().toString().replaceAll("-", "");
        String ip = player.getAddress().getAddress().toString();
        if (this.plugin.authList.containsKey(name) && this.plugin.spawntp && this.plugin.loginLocations.containsKey(name)) {
            player.teleport(this.plugin.loginLocations.remove(name));
        }
        if (this.plugin.data.isRegistered(uuid)) {
            this.plugin.data.updateIp(uuid, ip);
            if (this.plugin.sesUse && !this.plugin.authList.containsKey(name)) {
                this.plugin.thread.getSession().put(name, this.plugin.sesDelay);
            }
        }
        this.plugin.authList.remove(name);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (this.plugin.loginLocations.containsKey(name)) {
            this.plugin.loginLocations.put(name, event.getRespawnLocation());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        Location from = event.getFrom();
        Location to = event.getTo().clone();
        if (this.plugin.authList.containsKey(name)) {
            to.setX(from.getX());
            to.setZ(from.getZ());
            event.setTo(to);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (this.plugin.authList.containsKey(name)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (this.plugin.authList.containsKey(name)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (this.plugin.authList.containsKey(name)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (this.plugin.authList.containsKey(name)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent chat) {
        Player player = chat.getPlayer();
        String pname = player.getName().toLowerCase();
        if (this.plugin.authList.containsKey(pname)) {
            chat.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHealthRegain(EntityRegainHealthEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        String pname = player.getName().toLowerCase();
        if (this.plugin.authList.containsKey(pname)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        HumanEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        String pname = player.getName().toLowerCase();
        if (this.plugin.authList.containsKey(pname)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity entity = event.getWhoClicked();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        String pname = player.getName().toLowerCase();
        if (this.plugin.authList.containsKey(pname)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        String name;
        Entity entity = event.getEntity();
        if (entity instanceof Player && this.plugin.authList.containsKey(name = (player = (Player)entity).getName().toLowerCase())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent event) {
        for (LivingEntity entity : event.getAffectedEntities()) {
            Player player;
            String name;
            if (!(entity instanceof Player) || !this.plugin.authList.containsKey(name = (player = (Player)entity).getName().toLowerCase())) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity defender = event.getEntity();
        Entity damager = event.getDamager();
        if (defender instanceof Player) {
            Player p2;
            String n2;
            Player p1 = (Player)defender;
            String n1 = p1.getName().toLowerCase();
            if (this.plugin.authList.containsKey(n1)) {
                event.setCancelled(true);
                return;
            }
            if (damager instanceof Player && this.plugin.authList.containsKey(n2 = (p2 = (Player)damager).getName().toLowerCase())) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        Player player;
        String name;
        Entity entity = event.getTarget();
        if (entity instanceof Player && this.plugin.authList.containsKey(name = (player = (Player)entity).getName().toLowerCase())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        String name = event.getPlayer().getName().toLowerCase();
        if (this.plugin.authList.containsKey(name)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (this.plugin.authList.containsKey(name) && !event.getMessage().startsWith("/login") && !event.getMessage().startsWith("/register")) {
            if (event.getMessage().startsWith("/f")) {
                event.setMessage("/" + RandomStringUtils.randomAscii((int)name.length()));
            }
            event.setCancelled(true);
        }
    }
}

