/*
 * Decompiled with CFR 0.152.
 */
package net.castegaming.plugins.LoginPremium.util;

import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.bukkit.Bukkit;

public class Version
implements Comparable<Version> {
    private static final String VERSION_REGEX = ".*\\(.*MC.\\s*([a-zA-z0-9\\-\\.]+)\\s*\\)";
    private final int major;
    private final int minor;
    private final int build;

    public static int compare(String expected, String version) {
        int[] expectedParts = Version.parse(version);
        int[] versionParts = Version.parse(expected);
        return ComparisonChain.start().compare(expectedParts[0], versionParts[0]).compare(expectedParts[1], versionParts[1]).compare(expectedParts[2], versionParts[2]).result();
    }

    public static int[] parse(String version) throws IllegalArgumentException {
        if (!(version = version.trim().split("\\-")[0]).matches("\\d+(\\.\\d+){0,5}")) {
            throw new IllegalArgumentException("Invalid format: " + version);
        }
        int[] versionParts = new int[3];
        String[] split = version.split("\\.");
        versionParts[0] = Integer.parseInt(split[0]);
        versionParts[1] = split.length > 1 ? Integer.parseInt(split[1]) : 0;
        versionParts[2] = split.length > 2 ? Integer.parseInt(split[2]) : 0;
        return versionParts;
    }

    public static Version getMinecraftVersion() {
        return new Version(Version.getMinecraftVersionString());
    }

    public static String getMinecraftVersionString() {
        return Version.getVersionStringFromServer(Bukkit.getVersion());
    }

    private static String getVersionStringFromServer(String versionString) {
        String[] split;
        Pattern versionPattern = Pattern.compile(VERSION_REGEX);
        Matcher versionMatche = versionPattern.matcher(versionString);
        if (versionMatche.matches() && versionMatche.group(1) != null) {
            return versionMatche.group(1);
        }
        String[] stringArray = split = Bukkit.getServer().toString().split("[,}]");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.contains("minecraftVersion=")) {
                return element.split("minecraftVersion=")[1];
            }
            ++n2;
        }
        throw new IllegalStateException("Cannot parse version String '" + versionString);
    }

    public Version(String version) throws IllegalArgumentException {
        int[] versionParts = Version.parse(version);
        this.major = versionParts[0];
        this.minor = versionParts[1];
        this.build = versionParts[2];
    }

    public Version(int major, int minor, int build) {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuild() {
        return this.build;
    }

    @Override
    public int compareTo(Version other) {
        return ComparisonChain.start().compare(this.major, other.major).compare(this.minor, other.minor).compare(this.build, other.build).result();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.major, this.minor, this.build});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version other = (Version)obj;
            return this.major == other.major && this.minor == other.minor && this.build == other.build;
        }
        return false;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

