/*
 * Decompiled with CFR 0.152.
 */
package net.castegaming.plugins.LoginPremium;

import java.io.InputStream;
import net.castegaming.plugins.LoginPremium.LoginPremiumCommandListener;
import net.castegaming.plugins.LoginPremium.LoginPremiumConversions;
import net.castegaming.plugins.LoginPremium.LoginPremiumPlayerListener;
import net.castegaming.plugins.LoginPremium.managers.FactionsManager;
import net.castegaming.plugins.LoginPremium.managers.HeroesManager;
import net.castegaming.plugins.LoginPremium.managers.PexManager;
import net.castegaming.plugins.LoginPremium.managers.TownyManager;
import net.castegaming.plugins.LoginPremium.managers.VaultManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class LoginPremium
extends JavaPlugin {
    public static LoginPremium plugin;
    private LoginPremiumPlayerListener playerlistener;
    private LoginPremiumCommandListener commands = new LoginPremiumCommandListener(this);

    public void onEnable() {
        this.saveDefaultConfig();
        this.checkConfig();
        plugin = this;
        this.registerListeners();
        this.addManagers();
    }

    private void registerListeners() {
        PluginManager pm = this.getServer().getPluginManager();
        this.playerlistener = new LoginPremiumPlayerListener(this);
        pm.registerEvents((Listener)this.playerlistener, (Plugin)this);
    }

    public LoginPremiumPlayerListener getPlayerlistener() {
        return this.playerlistener;
    }

    public void addManagers() {
        if (LoginPremium.isPexEnabled()) {
            LoginPremiumConversions.addManager(new PexManager());
            this.log("PermissionsEX " + LoginPremium.getPEXVersion() + " has been found. Using it :3");
        } else if (LoginPremium.isVaultEnabled()) {
            LoginPremiumConversions.addManager(new VaultManager());
            this.log("Vault " + LoginPremium.getVaultVersion() + " has been found! Enabling groups :3");
        } else {
            this.log("PermissionsEX has not been found. Disabling our pEX features :(");
        }
        if (LoginPremium.isFactionsEnabled()) {
            LoginPremiumConversions.addManager(new FactionsManager());
            this.log("Factions " + LoginPremium.getFactionsVersion() + " has been found. Using it :3");
        } else {
            this.log("Factions has not been found. Disabling our Factions features :(");
        }
        if (LoginPremium.isTownyEnabled()) {
            LoginPremiumConversions.addManager(new TownyManager());
            this.log("Towny " + LoginPremium.getTownyVersion() + " has been found. Using it :3");
        } else {
            this.log("Towny has not been found. Disabling our Towny features :(");
        }
        if (LoginPremium.isHeroesEnabled()) {
            LoginPremiumConversions.addManager(new HeroesManager());
            this.log("Heroes " + LoginPremium.getHeroesVersion() + " has been found. Using it :3");
        } else {
            this.log("Heroes has not been found. Disabling our Heroes features :(");
        }
    }

    public void checkConfig() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((InputStream)this.getResource("config.yml"));
        for (String key : config.getKeys(false)) {
            if (this.getConfig().get(key) != null) continue;
            this.getConfig().set(key, config.get(key));
            this.log("Added the config value: " + key);
        }
    }

    public void onDisable() {
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        return this.commands.commandHandler(sender, cmd, args);
    }

    public static boolean isPexEnabled() {
        if (LoginPremium.isVaultEnabled()) {
            return false;
        }
        return Bukkit.getServer().getPluginManager().getPlugin("PermissionsEx") != null;
    }

    public static boolean isTownyEnabled() {
        return Bukkit.getServer().getPluginManager().getPlugin("Towny") != null;
    }

    public static boolean isVaultEnabled() {
        return Bukkit.getServer().getPluginManager().getPlugin("Vault") != null;
    }

    public static boolean isFactionsEnabled() {
        return Bukkit.getServer().getPluginManager().getPlugin("Factions") != null;
    }

    public static String getFactionsVersion() {
        if (LoginPremium.isFactionsEnabled()) {
            return Bukkit.getServer().getPluginManager().getPlugin("Factions").getDescription().getVersion();
        }
        return "0";
    }

    public static String getPEXVersion() {
        if (Bukkit.getServer().getPluginManager().getPlugin("PermissionsEx") != null) {
            return Bukkit.getServer().getPluginManager().getPlugin("PermissionsEx").getDescription().getVersion();
        }
        return "0";
    }

    public static String getVaultVersion() {
        if (LoginPremium.isVaultEnabled()) {
            return Bukkit.getServer().getPluginManager().getPlugin("Vault").getDescription().getVersion();
        }
        return "0";
    }

    public static String getTownyVersion() {
        if (LoginPremium.isTownyEnabled()) {
            return Bukkit.getServer().getPluginManager().getPlugin("Towny").getDescription().getVersion();
        }
        return "0";
    }

    public void log(String message) {
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.DARK_GREEN + "[" + ChatColor.DARK_RED + "LoginPremium " + this.getDescription().getVersion() + ChatColor.DARK_GREEN + "] " + ChatColor.RESET + message);
    }

    public static boolean isHeroesEnabled() {
        return Bukkit.getServer().getPluginManager().getPlugin("Heroes") != null;
    }

    public static String getHeroesVersion() {
        if (LoginPremium.isHeroesEnabled()) {
            return Bukkit.getServer().getPluginManager().getPlugin("Heroes").getDescription().getVersion();
        }
        return "0";
    }
}

