/*
 * Decompiled with CFR 0.152.
 */
package me.telesphoreo;

import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.telesphoreo.bukkit.Metrics;
import me.telesphoreo.commands.DeleteLoginMessage;
import me.telesphoreo.commands.LoginMessagesCommand;
import me.telesphoreo.commands.SetLoginMessage;
import me.telesphoreo.listener.PermissionLoginMessages;
import me.telesphoreo.listener.PlayerLoginMessages;
import me.telesphoreo.util.Updater;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LoginMessages
extends JavaPlugin {
    public static final BuildProperties build = new BuildProperties();
    private static final Pattern pattern = Pattern.compile("(?<!\\\\)(#[a-fA-F0-9]{6})");
    public static LoginMessages plugin;
    public static Server server;
    public static String pluginName;
    public static String pluginVersion;

    public String colorize(String message) {
        if (Bukkit.getBukkitVersion().contains("1.16") || Bukkit.getBukkitVersion().contains("1.17")) {
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String color = message.substring(matcher.start(), matcher.end());
                message = message.replace(color, "" + ChatColor.of((String)color));
            }
        }
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    public void onLoad() {
        plugin = this;
        server = plugin.getServer();
        pluginName = plugin.getDescription().getName();
        pluginVersion = plugin.getDescription().getVersion();
        this.saveDefaultConfig();
    }

    public void onEnable() {
        build.load(this);
        server.getPluginManager().registerEvents((Listener)new PlayerLoginMessages(), (Plugin)this);
        server.getPluginManager().registerEvents((Listener)new PermissionLoginMessages(), (Plugin)this);
        int pluginId = 2975;
        new Metrics(this, pluginId);
        this.registerCommands();
        try {
            Updater updater = new Updater(this);
            updater.update();
        }
        catch (NoClassDefFoundError ex) {
            this.getLogger().info("Failed to check for an update.");
        }
    }

    public void onDisable() {
    }

    public void registerCommands() {
        this.getCommand("deleteloginmessage").setExecutor((CommandExecutor)new DeleteLoginMessage());
        this.getCommand("loginmessages").setExecutor((CommandExecutor)new LoginMessagesCommand());
        this.getCommand("loginmessages").setTabCompleter((TabCompleter)new LoginMessagesCommand());
        this.getCommand("setloginmessage").setExecutor((CommandExecutor)new SetLoginMessage());
    }

    public void setLoginMessage(Player player, String message) {
        if (this.getConfig().get("players." + player.getName()) == null) {
            this.getConfig().createSection("players." + player.getName());
        }
        player.sendMessage(ChatColor.GRAY + "Your login message is now:");
        player.sendMessage(ChatColor.GRAY + "> " + ChatColor.RESET + this.colorize(message.replace("%player%", player.getName())));
        this.getConfig().set("players." + player.getName() + ".message", (Object)message);
        this.saveConfig();
        this.reloadConfig();
    }

    public void setLoginMessage(CommandSender sender, Player player, String message) {
        if (this.getConfig().get("players." + player.getName()) == null) {
            this.getConfig().createSection("players." + player.getName());
        }
        sender.sendMessage(ChatColor.GRAY + player.getName() + "'s login message is now:");
        sender.sendMessage(ChatColor.GRAY + "> " + ChatColor.RESET + this.colorize(message.replace("%player%", player.getName())));
        this.getConfig().set("players." + player.getName() + ".message", (Object)message);
        this.saveConfig();
        this.reloadConfig();
    }

    public void deleteLoginMessage(Player player) {
        if (this.getConfig().get("players." + player.getName()) == null) {
            player.sendMessage(ChatColor.RED + "You do not have a login message set.");
            return;
        }
        player.sendMessage(ChatColor.GRAY + "Your login message has been removed.");
        this.getConfig().set("players." + player.getName(), null);
        this.saveConfig();
        this.reloadConfig();
    }

    public void deleteLoginMessage(CommandSender sender, Player player) {
        if (this.getConfig().get("players." + player.getName()) == null) {
            sender.sendMessage(ChatColor.RED + player.getName() + " does not have a login message set.");
            return;
        }
        sender.sendMessage(ChatColor.GRAY + player.getName() + "'s login message has been removed.");
        this.getConfig().set("players." + player.getName(), null);
        this.saveConfig();
        this.reloadConfig();
    }

    public static class BuildProperties {
        public String author;
        public String version;
        public String number;
        public String date;
        public String head;

        void load(LoginMessages plugin) {
            try {
                Properties props;
                try (InputStream in = plugin.getResource("build.properties");){
                    props = new Properties();
                    props.load(in);
                }
                this.author = props.getProperty("buildAuthor", "unknown");
                this.version = props.getProperty("buildVersion", pluginVersion);
                this.number = props.getProperty("buildNumber", "1");
                this.date = props.getProperty("buildDate", "unknown");
                this.head = props.getProperty("buildHead", "unknown").replace("${git.commit.id.abbrev}", "unknown");
            }
            catch (Exception ex) {
                Bukkit.getLogger().severe("Could not load build properties! Did you compile with NetBeans/Maven?");
                Bukkit.getLogger().severe(ex.toString());
            }
        }
    }
}

