/*
 * Decompiled with CFR 0.152.
 */
package ziixs.loginmessages.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class YMLConfig
extends YamlConfiguration {
    private JavaPlugin pl;
    private File file;

    public YMLConfig(JavaPlugin pl, String name) {
        this.pl = pl;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("YAML file must have a name!");
        }
        if (!name.endsWith(".yml")) {
            name = String.valueOf(name) + ".yml";
        }
        this.file = new File(pl.getDataFolder(), name);
        this.reload();
    }

    public boolean reload() {
        boolean existed = this.file.exists();
        if (!this.file.exists()) {
            if (!this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            if (this.pl.getResource(this.file.getName()) != null) {
                this.pl.saveResource(this.file.getName(), true);
            } else {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.load(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
        }
        catch (Exception e) {
            this.pl.getLogger().severe("An error occurred while loading " + this.file.getName() + " on disk into RAM. This could be due to improper YAML syntax; copy-paste the file contents into http://yaml-online-parser.appspot.com/ to check the syntax.");
            e.printStackTrace();
        }
        if (this.pl.getResource(this.file.getName()) != null) {
            InputStreamReader defConfigStream = null;
            try {
                defConfigStream = new InputStreamReader(this.pl.getResource(this.file.getName()), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.pl.getLogger().severe("Unable to add default configuration options to " + this.file.getName());
                e.printStackTrace();
            }
            this.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)defConfigStream));
        }
        return existed;
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (Exception e) {
            this.pl.getLogger().severe("An error occurred while saving " + this.file.getName() + " from RAM to disk.");
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }
}

