/*
 * Decompiled with CFR 0.152.
 */
package de.pascal.Login.MySQL;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.bukkit.configuration.file.YamlConfiguration;

public class MySQL {
    private String host;
    private String user;
    private String port;
    private String database;
    private String password;
    private static Connection connection;
    private static File file;
    private static YamlConfiguration cfg;

    public static Connection getConnection() {
        return connection;
    }

    public static void setCreateConf() {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            cfg.options().copyDefaults(true);
            cfg.addDefault("MySQL.host", (Object)"host");
            cfg.addDefault("MySQL.user", (Object)"user");
            cfg.addDefault("MySQL.password", (Object)"password");
            cfg.addDefault("MySQL.database", (Object)"database");
            cfg.addDefault("MySQL.port", (Object)"port");
            try {
                cfg.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void LoadMySQLInits() {
        this.host = MySQL.getCfg().getString("MySQL.host");
        this.user = MySQL.getCfg().getString("MySQL.user");
        this.password = MySQL.getCfg().getString("MySQL.password");
        this.database = MySQL.getCfg().getString("MySQL.database");
        this.port = MySQL.getCfg().getString("MySQL.port");
    }

    public void connect() {
        try {
            connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database, this.user, this.password);
            System.out.println("[MySQL] Die verbindung wurde erfolgreich aufgebaut");
        }
        catch (SQLException e) {
            System.out.println("[MySQL] Ein Fehler ist aufgetreten");
            e.printStackTrace();
        }
    }

    private boolean isConnect() {
        return connection != null;
    }

    public void disconnect() {
        if (this.isConnect()) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void update(String qry) {
        try {
            PreparedStatement preparedStatement = MySQL.getConnection().prepareStatement(qry);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static YamlConfiguration getCfg() {
        return cfg;
    }

    static {
        file = new File("plugins/Login/MySQL.yml");
        cfg = YamlConfiguration.loadConfiguration((File)file);
    }
}

