/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import me.libraryaddict.inventory.ClickInventory;
import me.libraryaddict.inventory.InventoryApi;
import me.libraryaddict.inventory.events.PagesClickEvent;
import me.libraryaddict.inventory.events.PagesTurnEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public final class PageInventory
extends ClickInventory {
    protected ItemStack backAPage;
    protected ItemStack forwardsAPage;
    protected ItemStack exitInventory;
    protected int currentPage;
    protected boolean dynamicInventorySize = true;
    private int inventorySize = 54;
    protected boolean pageDisplayedInTitle;
    protected HashMap<Integer, ItemStack[]> pages = new HashMap();
    protected String title = "Inventory";
    private String titleFormat = "%Title% - Page %Page%";

    public PageInventory(Player player) {
        this(null, player);
    }

    public PageInventory(Player player, boolean dymanicInventory) {
        this(null, player, dymanicInventory);
    }

    public PageInventory(Player player, int inventorySize) {
        this(null, player, inventorySize);
    }

    public PageInventory(String inventoryName, Player player) {
        super(inventoryName, player);
    }

    public PageInventory(String inventoryName, Player player, boolean dymanicInventory) {
        super(inventoryName, player);
        this.dynamicInventorySize = dymanicInventory;
    }

    public PageInventory(String inventoryName, Player player, int inventorySize) {
        super(inventoryName, player);
        this.inventorySize = Math.min(54, (int)Math.ceil((double)inventorySize / 9.0) * 9);
        this.dynamicInventorySize = false;
        this.pages.put(0, new ItemStack[0]);
    }

    public ItemStack getExitInventory() {
        return this.exitInventory;
    }

    public void setExitInventory(ItemStack item) {
        this.exitInventory = item;
    }

    public ItemStack getBackPage() {
        if (this.backAPage == null) {
            this.backAPage = InventoryApi.setNameAndLore(new ItemStack(Material.SIGN), ChatColor.RED + "Back", ChatColor.BLUE + "Click this to move back");
        }
        return this.backAPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public ItemStack getForwardsPage() {
        if (this.forwardsAPage == null) {
            this.forwardsAPage = InventoryApi.setNameAndLore(new ItemStack(Material.SIGN), ChatColor.RED + "Forward", ChatColor.BLUE + "Click this to move forward");
        }
        return this.forwardsAPage;
    }

    @Override
    public String getTitle() {
        return this.getPageTitle();
    }

    public ItemStack[] getPage(int pageNumber) {
        if (this.pages.containsKey(pageNumber)) {
            return this.pages.get(pageNumber);
        }
        return null;
    }

    public HashMap<Integer, ItemStack[]> getPages() {
        return this.pages;
    }

    protected String getPageTitle() {
        return this.isPageDisplayedInTitle() ? this.titleFormat.replace("%Title%", this.title).replace("%Page%", this.getCurrentPage() + 1 + "") : this.title;
    }

    public boolean isPageDisplayedInTitle() {
        return this.pageDisplayedInTitle;
    }

    @Override
    protected void onInventoryClick(InventoryClickEvent event) {
        block11: {
            ItemStack item;
            block10: {
                item = event.getCurrentItem();
                if (!this.checkInMenu(event.getRawSlot())) break block10;
                if (item != null) {
                    int newPage = 0;
                    if (item.equals((Object)this.getBackPage())) {
                        newPage = -1;
                    } else if (item.equals((Object)this.getForwardsPage())) {
                        newPage = 1;
                    }
                    if (newPage != 0) {
                        PagesTurnEvent newEvent = new PagesTurnEvent(this, event.getSlot(), event, this.getCurrentPage() + newPage);
                        Bukkit.getPluginManager().callEvent((Event)newEvent);
                        if (!newEvent.isCancelled()) {
                            this.setPage(this.getCurrentPage() + newPage);
                        }
                        event.setCancelled(true);
                        return;
                    }
                }
                int slot = event.getSlot();
                if (this.isPlayerInventory() && (slot -= 9) < 0) {
                    slot += 36;
                }
                PagesClickEvent itemClickEvent = new PagesClickEvent(this, slot, event);
                if (!this.isModifiable()) {
                    itemClickEvent.setCancelled(true);
                }
                Bukkit.getPluginManager().callEvent((Event)itemClickEvent);
                if (!itemClickEvent.isCancelled()) break block11;
                event.setCancelled(true);
                break block11;
            }
            if (!this.isModifiable() && event.isShiftClick() && item != null && item.getType() != Material.AIR) {
                for (int slot = 0; slot < this.currentInventory.getSize(); ++slot) {
                    ItemStack invItem = this.currentInventory.getItem(slot);
                    if (invItem != null && invItem.getType() != Material.AIR && (!invItem.isSimilar(item) || item.getAmount() >= item.getMaxStackSize())) continue;
                    event.setCancelled(true);
                    break;
                }
            }
        }
    }

    public void openInventory() {
        if (this.isInventoryInUse()) {
            return;
        }
        this.saveContents();
        ItemStack[] pageItems = this.getItemsForPage();
        if (this.currentInventory == null) {
            this.currentInventory = this.isPlayerInventory() ? this.getPlayer().getInventory() : Bukkit.createInventory(null, (int)pageItems.length, (String)this.getPageTitle());
        }
        this.setItems(pageItems);
        this.openInv();
    }

    private ItemStack[] getItemsForPage() {
        ItemStack[] pageItems = this.pages.get(Math.max(this.getCurrentPage(), 0));
        int pageSize = pageItems.length;
        if (this.pages.size() > 1 || this.getExitInventory() != null) {
            pageSize += 9;
        }
        pageSize = !this.dynamicInventorySize || this.isPlayerInventory() ? (this.isPlayerInventory() ? 36 : this.inventorySize) : (pageSize + 8) / 9 * 9;
        pageItems = Arrays.copyOf(pageItems, pageSize);
        if (this.getCurrentPage() > 0 || this.getExitInventory() != null) {
            ItemStack itemStack = pageItems[pageItems.length - 9] = this.getCurrentPage() == 0 ? this.getExitInventory() : this.getBackPage();
        }
        if (this.pages.size() - 1 > this.getCurrentPage()) {
            pageItems[pageItems.length - 1] = this.getForwardsPage();
        }
        return pageItems;
    }

    public void setBackPage(ItemStack newBack) {
        this.backAPage = newBack;
    }

    public void setForwardsPage(ItemStack newForwards) {
        this.forwardsAPage = newForwards;
    }

    public ArrayList<ItemStack> getItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.pages.size(); ++i) {
            ItemStack[] itemArray = this.pages.get(i);
            for (int a = 0; a < itemArray.length - (this.pages.size() > 1 ? 9 : 0); ++a) {
                items.add(itemArray[a]);
            }
        }
        return items;
    }

    public void setPage(int newPage) {
        if (this.pages.containsKey(newPage)) {
            this.currentPage = newPage;
            if (this.isInventoryInUse()) {
                ItemStack[] pageItems = this.getItemsForPage();
                if (!(this.isPlayerInventory() || pageItems.length == this.currentInventory.getSize() && this.currentInventory.getTitle().equalsIgnoreCase(this.getPageTitle()))) {
                    this.currentInventory = Bukkit.createInventory(null, (int)pageItems.length, (String)this.getPageTitle());
                    this.currentInventory.setContents(pageItems);
                    this.openInv();
                } else {
                    this.setItems(pageItems);
                }
            }
        }
    }

    public void setPageDisplayedInTitle(boolean displayPage) {
        if (this.isPageDisplayedInTitle() != displayPage) {
            this.pageDisplayedInTitle = displayPage;
            if (this.isInventoryInUse()) {
                this.setPage(this.getCurrentPage());
            }
        }
    }

    public void setPageDisplayTitleFormat(String titleFormat) {
        this.titleFormat = titleFormat;
        if (this.isInventoryInUse()) {
            this.setPage(this.getCurrentPage());
        }
    }

    public void setPages(ArrayList<ItemStack> allItems) {
        this.setPages(allItems.toArray(new ItemStack[allItems.size()]));
    }

    public void setPages(ItemStack ... allItems) {
        this.pages.clear();
        int invPage = 0;
        boolean usePages = this.getExitInventory() != null || allItems.length > this.inventorySize;
        ItemStack[] items = null;
        int currentSlot = 0;
        int baseSize = this.isPlayerInventory() ? 36 : this.inventorySize;
        for (int currentItem = 0; currentItem < allItems.length; ++currentItem) {
            if (items == null) {
                int newSize = allItems.length - currentItem;
                if (usePages && newSize + 9 > baseSize) {
                    newSize = baseSize - 9;
                } else if (newSize > baseSize) {
                    newSize = baseSize;
                }
                items = new ItemStack[newSize];
            }
            ItemStack item = allItems[currentItem];
            items[currentSlot++] = item;
            if (currentSlot != items.length) continue;
            this.pages.put(invPage, items);
            ++invPage;
            currentSlot = 0;
            items = null;
        }
        if (this.pages.keySet().size() < this.getCurrentPage()) {
            this.currentPage = this.pages.keySet().size() - 1;
        }
        if (allItems.length == 0) {
            int size;
            int n = size = this.isPlayerInventory() ? 36 : this.inventorySize;
            if (!this.isPlayerInventory() && this.dynamicInventorySize) {
                size = 9;
            }
            items = InventoryApi.generateEmptyPage(size);
            if (this.getExitInventory() != null) {
                items[0] = this.getExitInventory();
            }
            this.pages.put(0, items);
        }
        this.setPage(this.getCurrentPage());
    }

    @Override
    public PageInventory setPlayerInventory() {
        super.setPlayerInventory();
        return this;
    }

    @Override
    public void setTitle(String newTitle) {
        if (!this.getTitle().equals(newTitle)) {
            this.title = newTitle;
            if (this.isInventoryInUse()) {
                this.setPage(this.getCurrentPage());
            }
        }
    }
}

