/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.inventory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.inventory.ClickInventory;
import me.libraryaddict.inventory.Page;
import me.libraryaddict.inventory.events.NamedPageClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public final class NamedInventory
extends ClickInventory {
    protected Page currentPage;
    protected HashMap<ItemStack, Page> pageDirectors = new HashMap();
    protected HashMap<Page, ItemStack[]> pages = new HashMap();

    public NamedInventory(Player player) {
        this(null, player);
    }

    @Deprecated
    public NamedInventory(Player player, boolean dymanicInventory) {
        this(player);
    }

    public NamedInventory(String inventoryName, Player player) {
        super(inventoryName, player);
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }

    public ItemStack[] getPage(Page page) {
        return this.pages.get(page);
    }

    public Page getPage(String pageName) {
        for (Page page : this.pages.keySet()) {
            if (!page.getPageName().equals(pageName)) continue;
            return page;
        }
        return null;
    }

    public Page getPageLink(ItemStack item) {
        return this.pageDirectors.get(item);
    }

    public HashMap<Page, ItemStack[]> getPages() {
        return this.pages;
    }

    @Override
    public String getTitle() {
        return this.currentPage.getPageDisplayTitle();
    }

    public void linkPage(ItemStack item, Page page) {
        this.pageDirectors.put(item, page);
    }

    public void linkPage(ItemStack item, String pageName) {
        Page page = this.getPage(pageName);
        if (page != null) {
            this.linkPage(item, page);
        }
    }

    @Override
    protected void onInventoryClick(InventoryClickEvent event) {
        block6: {
            ItemStack item;
            block5: {
                item = event.getCurrentItem();
                if (!this.checkInMenu(event.getRawSlot())) break block5;
                if (item != null && this.pageDirectors.containsKey(item)) {
                    event.setCancelled(true);
                    this.setPage(this.pageDirectors.get(item));
                    return;
                }
                int slot = event.getSlot();
                if (this.isPlayerInventory() && (slot -= 9) < 0) {
                    slot += 36;
                }
                NamedPageClickEvent itemClickEvent = new NamedPageClickEvent(this, this.currentPage, slot, event);
                if (!this.isModifiable()) {
                    itemClickEvent.setCancelled(true);
                }
                Bukkit.getPluginManager().callEvent((Event)itemClickEvent);
                if (!itemClickEvent.isCancelled()) break block6;
                event.setCancelled(true);
                break block6;
            }
            if (!this.isModifiable() && event.isShiftClick() && item != null && item.getType() != Material.AIR) {
                for (int slot = 0; slot < this.currentInventory.getSize(); ++slot) {
                    ItemStack invItem = this.currentInventory.getItem(slot);
                    if (invItem != null && invItem.getType() != Material.AIR && (!invItem.isSimilar(item) || invItem.getAmount() >= invItem.getMaxStackSize())) continue;
                    event.setCancelled(true);
                    break;
                }
            }
        }
    }

    public void openInventory() {
        if (this.isInventoryInUse()) {
            return;
        }
        if (this.isPlayerInventory()) {
            this.saveContents();
        }
        if (this.currentPage == null) {
            if (this.pages.isEmpty()) {
                this.pages.put(new Page("Inventory"), new ItemStack[0]);
            }
            this.currentPage = this.pages.keySet().iterator().next();
        }
        if (this.currentInventory == null) {
            ItemStack[] pageItems = this.getPage(this.currentPage);
            this.currentInventory = this.isPlayerInventory() ? this.getPlayer().getInventory() : Bukkit.createInventory(null, (int)pageItems.length, (String)this.getTitle());
            this.setItems(pageItems);
        }
        this.openInv();
    }

    public void removePage(Page page) {
        this.pages.remove(page);
    }

    public void setPage(Page newPage) {
        if (this.pages.containsKey(newPage)) {
            Page oldPage = this.currentPage;
            this.currentPage = newPage;
            if (this.isInventoryInUse()) {
                ItemStack[] pageItems = this.pages.get(this.currentPage);
                if (!(this.isPlayerInventory() || pageItems.length == this.currentInventory.getSize() && oldPage.getPageDisplayTitle().equals(this.getTitle()))) {
                    this.currentInventory = Bukkit.createInventory(null, (int)pageItems.length, (String)this.getTitle());
                    this.currentInventory.setContents(pageItems);
                    this.openInv();
                } else {
                    this.setItems(pageItems);
                }
            }
        }
    }

    public void setPage(Page page, ItemStack ... items) {
        if (items.length % 9 != 0) {
            items = Arrays.copyOf(items, (int)(Math.ceil((double)items.length / 9.0) * 9.0));
        }
        if (items.length > (this.isPlayerInventory() ? 36 : 54)) {
            throw new RuntimeException("A inventory size of " + items.length + " was passed when the max is " + (this.isPlayerInventory() ? 36 : 54));
        }
        this.pages.put(page, items);
        if (this.currentPage == null) {
            this.currentPage = page;
        } else if (this.currentPage.equals(page)) {
            this.setPage(page);
        }
    }

    public void setPage(Page page, List<ItemStack> items) {
        this.setPage(page, items.toArray(new ItemStack[items.size()]));
    }

    public void setPage(String pageName) {
        Page page = this.getPage(pageName);
        if (page != null) {
            this.setPage(page);
        }
    }

    @Override
    public NamedInventory setPlayerInventory() {
        super.setPlayerInventory();
        return this;
    }

    @Override
    public void setTitle(String newTitle) {
        if (newTitle != null && this.getCurrentPage() != null && !this.getCurrentPage().getPageDisplayTitle().equals(newTitle)) {
            this.setPage(new Page(this.getCurrentPage().getPageName(), newTitle), this.getPage(this.getCurrentPage()));
        }
    }

    public void unlinkPage(ItemStack item) {
        this.pageDirectors.remove(item);
    }
}

