/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.inventory;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import me.libraryaddict.inventory.ClickInventory;
import me.libraryaddict.inventory.ItemBuilder;
import me.libraryaddict.inventory.events.AnvilClickEvent;
import me.libraryaddict.inventory.events.AnvilTypeEvent;
import net.minecraft.server.v1_7_R4.ContainerAnvil;
import net.minecraft.server.v1_7_R4.EntityHuman;
import net.minecraft.server.v1_7_R4.EntityPlayer;
import net.minecraft.server.v1_7_R4.ICrafting;
import net.minecraft.util.com.google.common.base.Objects;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AnvilInventory
extends ClickInventory {
    private HashMap<AnvilSlot, ItemStack> items = new HashMap();
    private String itemName;
    private HashMap<Object, Object> data = new HashMap();

    public void setItemName(String newString) {
        if (!Objects.equal((Object)newString, (Object)this.itemName)) {
            ItemBuilder builder = new ItemBuilder(Material.PAPER);
            ItemStack item = this.currentInventory.getItem(AnvilSlot.OUTPUT.getSlot());
            if (item != null && item.getType() != Material.AIR) {
                builder = new ItemBuilder(item);
            }
            builder.setRawTitle(newString);
            this.itemName = newString;
            this.setSlot(AnvilSlot.INPUT_LEFT, builder.build());
        }
    }

    @Override
    public Object getData(Object obj) {
        if (this.data.containsKey(obj)) {
            return this.data.get(obj);
        }
        return null;
    }

    @Override
    public AnvilInventory setData(Object obj, Object value) {
        this.data.put(obj, value);
        return this;
    }

    public String getItemName() {
        return this.itemName;
    }

    public AnvilInventory(String inventoryName, Player player) {
        super(inventoryName, player);
    }

    public void setSlot(AnvilSlot slot, ItemStack item) {
        this.items.put(slot, item);
        if (this.currentInventory != null) {
            this.currentInventory.setItem(slot.getSlot(), item);
        }
        if (item != null && item.hasItemMeta()) {
            this.itemName = item.getItemMeta().getDisplayName();
            if (this.itemName == null) {
                this.itemName = "";
            }
        }
    }

    public void openInventory() {
        if (this.isInventoryInUse()) {
            return;
        }
        EntityPlayer p = ((CraftPlayer)this.getPlayer()).getHandle();
        AnvilContainer container = new AnvilContainer((EntityHuman)p);
        this.openInv();
        int c = p.nextContainerCounter();
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.OPEN_WINDOW);
        StructureModifier mods = packet.getModifier();
        mods.write(0, (Object)c);
        mods.write(1, (Object)8);
        mods.write(2, (Object)"Repairing");
        mods.write(3, (Object)9);
        mods.write(4, (Object)true);
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(this.getPlayer(), packet);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        p.activeContainer = container;
        p.activeContainer.windowId = c;
        p.activeContainer.addSlotListener((ICrafting)p);
        this.currentInventory = container.getBukkitView().getTopInventory();
        for (AnvilSlot slot : this.items.keySet()) {
            this.currentInventory.setItem(slot.getSlot(), this.items.get((Object)slot));
        }
    }

    @Override
    public void closeInventory(boolean forceClose) {
        this.currentInventory.clear();
        super.closeInventory(forceClose);
    }

    @Override
    public void closeInventory() {
        this.currentInventory.clear();
        super.closeInventory();
    }

    public ItemStack getItem(AnvilSlot slot) {
        ItemStack item = this.currentInventory == null ? this.items.get((Object)slot) : this.currentInventory.getItem(slot.getSlot());
        ItemBuilder builder = new ItemBuilder(item);
        builder.setRawTitle(this.getItemName());
        return builder.build();
    }

    @Override
    protected void onInventoryClick(InventoryClickEvent event) {
        if (event.getRawSlot() < 3) {
            AnvilClickEvent clickEvent = new AnvilClickEvent(this, AnvilSlot.bySlot(event.getRawSlot()), event);
            if (!this.isModifiable()) {
                clickEvent.setCancelled(true);
            }
            Bukkit.getPluginManager().callEvent((Event)clickEvent);
            if (clickEvent.isCancelled()) {
                event.setCancelled(true);
            }
        } else if (event.isShiftClick()) {
            event.setCancelled(true);
        }
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public void setTitle(String newTitle) {
    }

    public static enum AnvilSlot {
        INPUT_LEFT(0),
        INPUT_RIGHT(1),
        OUTPUT(2);

        private int slot;

        private AnvilSlot(int slot) {
            this.slot = slot;
        }

        public int getSlot() {
            return this.slot;
        }

        public static AnvilSlot bySlot(int slot) {
            for (AnvilSlot anvilSlot : AnvilSlot.values()) {
                if (anvilSlot.getSlot() != slot) continue;
                return anvilSlot;
            }
            return null;
        }
    }

    private class AnvilContainer
    extends ContainerAnvil {
        private String n;

        public AnvilContainer(EntityHuman entity) {
            super(entity.inventory, entity.world, 0, 0, 0, entity);
        }

        public boolean a(EntityHuman entityhuman) {
            return true;
        }

        public void a(String origString) {
            AnvilTypeEvent event = new AnvilTypeEvent(AnvilInventory.this, origString);
            Bukkit.getPluginManager().callEvent((Event)event);
            String newString = event.getString();
            if (!event.isCancelled()) {
                this.n = newString;
                AnvilInventory.this.itemName = origString;
                AnvilInventory.this.setItemName(newString);
                if (this.getSlot(2).hasItem()) {
                    net.minecraft.server.v1_7_R4.ItemStack itemstack = this.getSlot(2).getItem();
                    if (StringUtils.isBlank((String)newString)) {
                        itemstack.t();
                    } else {
                        itemstack.c(this.n);
                    }
                }
            }
            this.e();
        }
    }
}

