/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.core;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSocketFactory;

public class BalancedSSLFactory
extends SSLSocketFactory {
    private final SSLSocketFactory oldFactory;
    private final List<InetAddress> localAddresses;
    private AtomicInteger id;

    public BalancedSSLFactory(SSLSocketFactory oldFactory, Iterable<InetAddress> localAddresses) {
        this.oldFactory = oldFactory;
        this.localAddresses = ImmutableList.copyOf(localAddresses);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.oldFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.oldFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.oldFactory.createSocket(host, port, this.getNextLocalAddress(), 0);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.oldFactory.createSocket(host, port, this.getNextLocalAddress(), 0);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.oldFactory.createSocket(host, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.oldFactory.createSocket(host, port, this.getNextLocalAddress(), 0);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress local, int localPort) throws IOException {
        return this.oldFactory.createSocket(host, port, local, localPort);
    }

    private InetAddress getNextLocalAddress() {
        int index = this.id.incrementAndGet() % this.localAddresses.size();
        return this.localAddresses.get(index);
    }
}

