/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bungee.listener;

import com.github.games647.fastlogin.bungee.BungeeLoginSession;
import com.github.games647.fastlogin.bungee.FastLoginBungee;
import com.github.games647.fastlogin.bungee.tasks.AsyncToggleMessage;
import com.github.games647.fastlogin.core.PlayerProfile;
import com.github.games647.fastlogin.core.shared.FastLoginCore;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.util.Arrays;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class PluginMessageListener
implements Listener {
    private final FastLoginBungee plugin;

    public PluginMessageListener(FastLoginBungee plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent pluginMessageEvent) {
        String channel = pluginMessageEvent.getTag();
        if (pluginMessageEvent.isCancelled() || !this.plugin.getDescription().getName().equals(channel)) {
            return;
        }
        pluginMessageEvent.setCancelled(true);
        if (Server.class.isAssignableFrom(pluginMessageEvent.getSender().getClass())) {
            byte[] data = Arrays.copyOf(pluginMessageEvent.getData(), pluginMessageEvent.getData().length);
            ProxiedPlayer forPlayer = (ProxiedPlayer)pluginMessageEvent.getReceiver();
            ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, () -> this.readMessage(forPlayer, data));
        }
    }

    private void readMessage(ProxiedPlayer forPlayer, byte[] data) {
        FastLoginCore<ProxiedPlayer, CommandSender, FastLoginBungee> core = this.plugin.getCore();
        ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])data);
        String subchannel = dataInput.readUTF();
        if ("SUCCESS".equals(subchannel)) {
            this.onSuccessMessage(forPlayer);
        } else if ("ON".equals(subchannel)) {
            String playerName = dataInput.readUTF();
            boolean isPlayerSender = dataInput.readBoolean();
            if (playerName.equals(forPlayer.getName()) && this.plugin.getCore().getConfig().get("premium-warning", true).booleanValue() && !core.getPendingConfirms().contains(forPlayer.getUniqueId())) {
                String message = core.getMessage("premium-warning");
                forPlayer.sendMessage(TextComponent.fromLegacyText((String)message));
                core.getPendingConfirms().add(forPlayer.getUniqueId());
                return;
            }
            core.getPendingConfirms().remove(forPlayer.getUniqueId());
            AsyncToggleMessage task = new AsyncToggleMessage(core, forPlayer, playerName, true, isPlayerSender);
            ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, (Runnable)task);
        } else if ("OFF".equals(subchannel)) {
            String playerName = dataInput.readUTF();
            boolean isPlayerSender = dataInput.readBoolean();
            AsyncToggleMessage task = new AsyncToggleMessage(core, forPlayer, playerName, false, isPlayerSender);
            ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, (Runnable)task);
        }
    }

    private void onSuccessMessage(ProxiedPlayer forPlayer) {
        if (forPlayer.getPendingConnection().isOnlineMode()) {
            BungeeLoginSession loginSession = (BungeeLoginSession)this.plugin.getSession().get(forPlayer.getPendingConnection());
            PlayerProfile playerProfile = loginSession.getProfile();
            loginSession.setRegistered(true);
            if (!loginSession.isAlreadySaved()) {
                playerProfile.setPremium(true);
                this.plugin.getCore().getStorage().save(playerProfile);
                loginSession.setAlreadySaved(true);
            }
        }
    }
}

