/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.hooks;

import com.github.games647.fastlogin.core.hooks.AuthPlugin;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.royaldev.royalauth.AuthPlayer;
import org.royaldev.royalauth.Config;
import org.royaldev.royalauth.RoyalAuth;

public class RoyalAuthHook
implements AuthPlugin<Player> {
    private final Plugin royalAuthPlugin = (RoyalAuth)Bukkit.getPluginManager().getPlugin("RoyalAuth");

    @Override
    public boolean forceLogin(Player player) {
        AuthPlayer authPlayer = AuthPlayer.getAuthPlayer((Player)player);
        Future future = Bukkit.getScheduler().callSyncMethod(this.royalAuthPlugin, () -> {
            if (authPlayer.isLoggedIn()) {
                return true;
            }
            authPlayer.login();
            return authPlayer.isLoggedIn();
        });
        try {
            return (Boolean)future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            this.royalAuthPlugin.getLogger().log(Level.SEVERE, "Failed to forceLogin", ex);
            return false;
        }
    }

    @Override
    public boolean isRegistered(String playerName) throws Exception {
        AuthPlayer authPlayer = AuthPlayer.getAuthPlayer((String)playerName);
        return authPlayer.isRegistered();
    }

    @Override
    public boolean forceRegister(Player player, String password) {
        AuthPlayer authPlayer = AuthPlayer.getAuthPlayer((Player)player);
        boolean registerSuccess = authPlayer.setPassword(password, Config.passwordHashType);
        return registerSuccess && this.forceLogin(player);
    }
}

