/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.hooks;

import com.github.games647.fastlogin.core.hooks.AuthPlugin;
import de.st_ddt.crazylogin.CrazyLogin;
import de.st_ddt.crazylogin.data.LoginPlayerData;
import de.st_ddt.crazylogin.databases.CrazyLoginDataDatabase;
import de.st_ddt.crazylogin.listener.PlayerListener;
import de.st_ddt.crazylogin.metadata.Authenticated;
import de.st_ddt.crazyutil.databases.DatabaseEntry;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.apache.commons.lang.reflect.FieldUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CrazyLoginHook
implements AuthPlugin<Player> {
    private final CrazyLogin crazyLoginPlugin = CrazyLogin.getPlugin();
    private final PlayerListener playerListener = this.getListener();

    @Override
    public boolean forceLogin(Player player) {
        Future future = Bukkit.getScheduler().callSyncMethod((Plugin)this.crazyLoginPlugin, () -> {
            LoginPlayerData playerData = (LoginPlayerData)this.crazyLoginPlugin.getPlayerData((OfflinePlayer)player);
            if (playerData != null) {
                playerData.setLoggedIn(true);
                String ip = player.getAddress().getAddress().getHostAddress();
                playerData.resetLoginFails();
                player.setFireTicks(0);
                if (this.playerListener != null) {
                    this.playerListener.removeMovementBlocker((OfflinePlayer)player);
                    this.playerListener.disableHidenInventory(player);
                    this.playerListener.disableSaveLogin(player);
                    this.playerListener.unhidePlayer(player);
                }
                playerData.addIP(ip);
                player.setMetadata("Authenticated", (MetadataValue)new Authenticated(this.crazyLoginPlugin, (OfflinePlayer)player));
                this.crazyLoginPlugin.unregisterDynamicHooks();
                return playerData;
            }
            return null;
        });
        try {
            LoginPlayerData result = (LoginPlayerData)future.get();
            if (result != null && result.isLoggedIn()) {
                this.crazyLoginPlugin.getCrazyDatabase().saveWithoutPassword(result);
                return true;
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            this.crazyLoginPlugin.getLogger().log(Level.SEVERE, "Failed to forceLogin", ex);
            return false;
        }
        return false;
    }

    @Override
    public boolean isRegistered(String playerName) throws Exception {
        return this.crazyLoginPlugin.getPlayerData(playerName) != null;
    }

    @Override
    public boolean forceRegister(Player player, String password) {
        CrazyLoginDataDatabase crazyDatabase = this.crazyLoginPlugin.getCrazyDatabase();
        LoginPlayerData playerData = (LoginPlayerData)this.crazyLoginPlugin.getPlayerData(player.getName());
        if (playerData == null) {
            playerData = new LoginPlayerData(player);
            crazyDatabase.save((DatabaseEntry)playerData);
            return this.forceLogin(player);
        }
        return false;
    }

    private PlayerListener getListener() {
        PlayerListener listener;
        try {
            listener = (PlayerListener)FieldUtils.readField((Object)this.crazyLoginPlugin, (String)"playerListener", (boolean)true);
        }
        catch (IllegalAccessException ex) {
            this.crazyLoginPlugin.getLogger().log(Level.SEVERE, "Failed to get the listener instance for auto login", ex);
            listener = null;
        }
        return listener;
    }
}

