/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit;

import com.github.games647.fastlogin.bukkit.BukkitLoginSession;
import com.github.games647.fastlogin.bukkit.EncryptionUtil;
import com.github.games647.fastlogin.bukkit.MojangApiBukkit;
import com.github.games647.fastlogin.bukkit.PremiumPlaceholder;
import com.github.games647.fastlogin.bukkit.commands.CrackedCommand;
import com.github.games647.fastlogin.bukkit.commands.PremiumCommand;
import com.github.games647.fastlogin.bukkit.listener.BukkitJoinListener;
import com.github.games647.fastlogin.bukkit.listener.BungeeCordListener;
import com.github.games647.fastlogin.bukkit.listener.protocollib.LoginSkinApplyListener;
import com.github.games647.fastlogin.bukkit.listener.protocollib.ProtocolLibListener;
import com.github.games647.fastlogin.bukkit.listener.protocolsupport.ProtocolSupportListener;
import com.github.games647.fastlogin.bukkit.tasks.DelayedAuthHook;
import com.github.games647.fastlogin.core.shared.FastLoginCore;
import com.github.games647.fastlogin.core.shared.MojangApiConnector;
import com.github.games647.fastlogin.core.shared.PlatformPlugin;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.Reader;
import java.security.KeyPair;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.plugin.messaging.PluginMessageRecipient;

public class FastLoginBukkit
extends JavaPlugin
implements PlatformPlugin<CommandSender> {
    private final KeyPair keyPair = EncryptionUtil.generateKeyPair();
    private boolean bungeeCord;
    private FastLoginCore<Player, CommandSender, FastLoginBukkit> core;
    private boolean serverStarted;
    private final ConcurrentMap<String, BukkitLoginSession> loginSession = FastLoginCore.buildCache(1, -1);

    public void onEnable() {
        this.core = new FastLoginCore(this);
        this.core.load();
        try {
            this.bungeeCord = Class.forName("org.spigotmc.SpigotConfig").getDeclaredField("bungee").getBoolean(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Cannot check bungeecord support. You use a non-spigot build", ex);
        }
        if (this.getServer().getOnlineMode()) {
            this.getLogger().severe("Server have to be in offline mode");
            this.setEnabled(false);
            return;
        }
        if (this.bungeeCord) {
            this.setServerStarted();
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, this.getName(), (PluginMessageListener)new BungeeCordListener(this));
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, this.getName());
        } else {
            if (!this.core.setupDatabase()) {
                this.setEnabled(false);
                return;
            }
            if (this.getServer().getPluginManager().isPluginEnabled("ProtocolSupport")) {
                this.getServer().getPluginManager().registerEvents((Listener)new ProtocolSupportListener(this), (Plugin)this);
            } else if (this.getServer().getPluginManager().isPluginEnabled("ProtocolLib")) {
                ProtocolLibListener.register(this);
                this.getServer().getPluginManager().registerEvents((Listener)new LoginSkinApplyListener(this), (Plugin)this);
            } else {
                this.getLogger().warning("Either ProtocolLib or ProtocolSupport have to be installed if you don't use BungeeCord");
            }
        }
        this.getServer().getScheduler().runTaskLater((Plugin)this, (Runnable)new DelayedAuthHook(this), 5L);
        this.getServer().getPluginManager().registerEvents((Listener)new BukkitJoinListener(this), (Plugin)this);
        this.getCommand("premium").setExecutor((CommandExecutor)new PremiumCommand(this));
        this.getCommand("cracked").setExecutor((CommandExecutor)new CrackedCommand(this));
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            PremiumPlaceholder.register(this);
        }
    }

    public void onDisable() {
        this.loginSession.clear();
        if (this.core != null) {
            this.core.close();
        }
        this.getServer().getOnlinePlayers().forEach(player -> player.removeMetadata(this.getName(), (Plugin)this));
    }

    public FastLoginCore<Player, CommandSender, FastLoginBukkit> getCore() {
        return this.core;
    }

    public void sendBungeeActivateMessage(CommandSender sender, String target, boolean activate) {
        if (sender instanceof Player) {
            this.notifyBungeeCord((PluginMessageRecipient)((Player)sender), target, activate, sender instanceof Player);
        } else {
            Player firstPlayer = (Player)Iterables.getFirst((Iterable)this.getServer().getOnlinePlayers(), null);
            if (firstPlayer == null) {
                this.getLogger().info("No player online to send a plugin message to the proxy");
                return;
            }
            this.notifyBungeeCord((PluginMessageRecipient)firstPlayer, target, activate, sender instanceof Player);
        }
    }

    public ConcurrentMap<String, BukkitLoginSession> getLoginSessions() {
        return this.loginSession;
    }

    public KeyPair getServerKey() {
        return this.keyPair;
    }

    public boolean isBungeeCord() {
        return this.bungeeCord;
    }

    public boolean isServerFullyStarted() {
        return this.serverStarted;
    }

    public void setServerStarted() {
        if (!this.serverStarted) {
            this.serverStarted = true;
        }
    }

    private void notifyBungeeCord(PluginMessageRecipient sender, String target, boolean activate, boolean isPlayer) {
        ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
        if (activate) {
            dataOutput.writeUTF("ON");
        } else {
            dataOutput.writeUTF("OFF");
        }
        dataOutput.writeUTF(target);
        dataOutput.writeBoolean(isPlayer);
        sender.sendPluginMessage((Plugin)this, this.getName(), dataOutput.toByteArray());
    }

    @Override
    public Map<String, Object> loadYamlFile(Reader reader) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
        return config.getValues(true);
    }

    @Override
    public void sendMessage(CommandSender receiver, String message) {
        receiver.sendMessage(message);
    }

    @Override
    public String translateColorCodes(char colorChar, String rawMessage) {
        return ChatColor.translateAlternateColorCodes((char)colorChar, (String)rawMessage);
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return null;
    }

    @Override
    public MojangApiConnector makeApiConnector(Logger logger, List<String> addresses, int requests, Map<String, Integer> proxies) {
        return new MojangApiBukkit(logger, addresses, requests, proxies);
    }
}

