/*
 * Decompiled with CFR 0.152.
 */
package com.graybackteam.fastlogin;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private Material mat;
    private int amount = 1;
    private short data = 0;
    private String name;
    private List<String> lore = new ArrayList<String>();
    private boolean glowing = false;

    public static ItemBuilder builder() {
        return new ItemBuilder();
    }

    public ItemBuilder material(Material mat) {
        this.mat = mat;
        return this;
    }

    public ItemBuilder withGlow() {
        this.glowing = true;
        return this;
    }

    public ItemBuilder withGlow(boolean glow) {
        this.glowing = glow;
        return this;
    }

    public ItemBuilder forkFrom(ItemStack is) {
        this.mat = is.getType();
        this.amount = is.getAmount();
        this.data = is.getData().getData();
        this.name = is.getItemMeta().getDisplayName();
        this.lore = is.getItemMeta().getLore();
        return this;
    }

    public ItemBuilder forkWithoutLore(ItemStack is) {
        this.mat = is.getType();
        this.amount = is.getAmount();
        this.data = is.getData().getData();
        this.name = is.getItemMeta().getDisplayName();
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.amount = amount;
        return this;
    }

    public ItemBuilder data(short data) {
        this.data = data;
        return this;
    }

    public ItemBuilder name(String name) {
        this.name = name.equals("") ? "" : ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        return this;
    }

    public ItemBuilder lore(String ... lore) {
        for (String l : lore) {
            this.lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)l));
        }
        return this;
    }

    public ItemBuilder lore(List<String> lore) {
        for (String l : lore) {
            this.lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)l));
        }
        return this;
    }

    public ItemStack build() {
        ItemStack item = new ItemStack(this.mat, this.amount, this.data);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.name);
        meta.setLore(this.lore);
        if (this.glowing) {
            meta.addEnchant(Enchantment.DAMAGE_ALL, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }
}

