/*
 * Decompiled with CFR 0.152.
 */
package com.eveningmc.customlogin.utils;

import com.eveningmc.customlogin.Customlogin;
import java.util.logging.Level;

public class Message {
    public static void log(String message) {
        Customlogin.getInstance().getLogger().info(message);
    }

    public static void log(Level level, String message) {
        Customlogin.getInstance().getLogger().log(level, message);
    }

    public static void debug(String message) {
        if (Customlogin.getInstance().getConfiguration().getConfig("", "settings").getBoolean("Debug")) {
            Message.log("< DEBUG > " + message);
        }
    }

    public static void debug(Level level, String message) {
        if (Customlogin.getInstance().getConfiguration().getConfig("", "settings").getBoolean("Debug")) {
            Message.log(level, "< DEBUG > " + message);
        }
    }

    public static String format(String message) {
        return message.replaceAll("&", "\u00a7");
    }

    public static String formatMessage(String message) {
        message = Message.format("&9" + Customlogin.getInstance().getName() + " > &a" + message);
        return message;
    }

    public static String formatError(String message) {
        message = Message.format("&9" + Customlogin.getInstance().getName() + " > &c" + message);
        return message;
    }

    public static String toString(String[] arguments, int start) {
        String returnString = "";
        int count = start;
        while (count < arguments.length) {
            returnString = count == start ? arguments[count] : String.valueOf(returnString) + " " + arguments[count];
            ++count;
        }
        return returnString;
    }
}

