/*
 * Decompiled with CFR 0.152.
 */
package com.eveningmc.customlogin.configs;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationManager {
    public File folder;
    public File file;
    public FileConfiguration config;

    public FileConfiguration getConfig(String folderName, String fileName) {
        this.folder = new File("plugins/EveningMC/Customlogin/" + folderName);
        this.file = new File(this.folder, String.valueOf(fileName) + ".yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        if (this.config == null) {
            this.createFile(folderName, fileName);
        }
        return this.config;
    }

    public void createFile(String folderName, String fileName) {
        this.folder = new File("plugins/EveningMC/Customlogin/" + folderName);
        if (!this.folder.exists()) {
            this.folder.mkdir();
        }
        this.file = new File(this.folder, String.valueOf(fileName) + ".yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
                this.save(folderName, fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
        }
    }

    public void save(String folderName, String fileName) {
        this.folder = new File("plugins/EveningMC/Customlogin/" + folderName);
        this.file = new File(this.folder, String.valueOf(fileName) + ".yml");
        if (this.config == null) {
            return;
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void set(String folderName, String fileName, String path, Object o) {
        this.folder = new File("plugins/EveningMC/Customlogin/" + folderName);
        this.file = new File(this.folder, String.valueOf(fileName) + ".yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        if (!this.config.contains(path)) {
            this.getConfig(folderName, fileName).set(path, o);
            this.save(folderName, fileName);
        }
    }

    public void setOverride(String folderName, String fileName, String path, Object o) {
        this.folder = new File("plugins/EveningMC/Customlogin/" + folderName);
        this.file = new File(this.folder, String.valueOf(fileName) + ".yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.getConfig(folderName, fileName).set(path, o);
        this.save(folderName, fileName);
    }

    public Object get(String folderName, String fileName, String path) {
        this.folder = new File("plugins/EveningMC/Customlogin/" + folderName);
        this.file = new File(this.folder, String.valueOf(fileName) + ".yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        return this.config.get(path);
    }

    public Object get(String folderName, String fileName, String path, Object o) {
        this.folder = new File("plugins/EveningMC/Customlogin/" + folderName);
        this.file = new File(this.folder, String.valueOf(fileName) + ".yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        return this.config.get(path, o);
    }
}

